<?php
// SITE PÚBLICO - INDEX
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Troya Imóveis - Seu lar dos sonhos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --primary: #238636;
            --dark: #0d1117;
            --darker: #161b22;
            --border: #30363d;
            --text: #e6edf3;
        }
        body { background: var(--dark); color: var(--text); font-family: system-ui; }
        .hero { background: linear-gradient(135deg, var(--darker) 0%, var(--dark) 100%); padding: 4rem 0; }
        .property-card { background: var(--darker); border: 1px solid var(--border); border-radius: 8px; transition: transform 0.2s; }
        .property-card:hover { transform: translateY(-4px); }
        .btn-primary { background: var(--primary); border-color: var(--primary); }
        .btn-primary:hover { background: #2ea043; border-color: #2ea043; }
    </style>
</head>
<body>
    <!-- HEADER -->
    <nav class="navbar navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="bi bi-house-door me-2"></i>Troya Imóveis
            </a>
            <ul class="navbar-nav">
                <li class="nav-item"><a class="nav-link" href="index.php">Imóveis</a></li>
                <li class="nav-item"><a class="nav-link" href="contato.php">Contato</a></li>
                <li class="nav-item"><a class="nav-link" href="sobre.php">Sobre</a></li>
            </ul>
        </div>
    </nav>

    <!-- HERO -->
    <section class="hero">
        <div class="container text-center">
            <h1 class="display-4 mb-4">Encontre seu lar dos sonhos</h1>
            <p class="lead mb-4">Imóveis de qualidade em localizações privilegiadas</p>
            <a href="#imoveis" class="btn btn-primary btn-lg">Ver Imóveis</a>
        </div>
    </section>

    <!-- FILTROS -->
    <section class="container my-5">
        <div class="row">
            <div class="col-md-3">
                <h5><i class="bi bi-geo-alt me-2"></i>Localização</h5>
                <select class="form-select bg-dark text-white border-secondary">
                    <option>Belo Horizonte</option>
                    <option>Nova Lima</option>
                    <option>Contagem</option>
                </select>
            </div>
            <div class="col-md-3">
                <h5><i class="bi bi-house me-2"></i>Tipo</h5>
                <select class="form-select bg-dark text-white border-secondary">
                    <option>Casa</option>
                    <option>Apartamento</option>
                    <option>Kitnet</option>
                </select>
            </div>
            <div class="col-md-3">
                <h5><i class="bi bi-currency-dollar me-2"></i>Preço</h5>
                <select class="form-select bg-dark text-white border-secondary">
                    <option>Até R$ 300.000</option>
                    <option>R$ 300.000 - R$ 600.000</option>
                    <option>Acima de R$ 600.000</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-primary w-100">Buscar Imóveis</button>
            </div>
        </div>
    </section>

    <!-- IMÓVEIS -->
    <section id="imoveis" class="container my-5">
        <h2 class="text-center mb-5">Imóveis Disponíveis</h2>
        <div class="row">
            <!-- IMÓVEL 1 -->
            <div class="col-md-4 mb-4">
                <div class="property-card h-100">
                    <img src="https://via.placeholder.com/400x250/161b22/e6edf3?text=Casa+3+Quartos" class="card-img-top" alt="Casa">
                    <div class="card-body">
                        <h5 class="card-title">Casa 3 Quartos - Centro</h5>
                        <p class="card-text text-success fw-bold">R$ 850.000</p>
                        <p class="card-text"><i class="bi bi-geo-alt me-1"></i>Belo Horizonte, MG</p>
                        <p class="card-text"><i class="bi bi-house-door me-1"></i>180m² • 3 quartos • 2 vagas</p>
                        <a href="imovel.php?id=1" class="btn btn-primary w-100">Ver Detalhes</a>
                    </div>
                </div>
            </div>

            <!-- IMÓVEL 2 -->
            <div class="col-md-4 mb-4">
                <div class="property-card h-100">
                    <img src="https://via.placeholder.com/400x250/161b22/e6edf3?text=Apartamento+2+Quartos" class="card-img-top" alt="Apartamento">
                    <div class="card-body">
                        <h5 class="card-title">Apartamento 2 Quartos - Savassi</h5>
                        <p class="card-text text-success fw-bold">R$ 2.500/mês</p>
                        <p class="card-text"><i class="bi bi-geo-alt me-1"></i>Belo Horizonte, MG</p>
                        <p class="card-text"><i class="bi bi-house-door me-1"></i>85m² • 2 quartos • 1 vaga</p>
                        <a href="imovel.php?id=2" class="btn btn-primary w-100">Ver Detalhes</a>
                    </div>
                </div>
            </div>

            <!-- IMÓVEL 3 -->
            <div class="col-md-4 mb-4">
                <div class="property-card h-100">
                    <img src="https://via.placeholder.com/400x250/161b22/e6edf3?text=Casa+4+Quartos" class="card-img-top" alt="Casa">
                    <div class="card-body">
                        <h5 class="card-title">Casa 4 Quartos - Nova Lima</h5>
                        <p class="card-text text-success fw-bold">R$ 1.200.000</p>
                        <p class="card-text"><i class="bi bi-geo-alt me-1"></i>Nova Lima, MG</p>
                        <p class="card-text"><i class="bi bi-house-door me-1"></i>250m² • 4 quartos • Piscina</p>
                        <a href="imovel.php?id=3" class="btn btn-primary w-100">Ver Detalhes</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FOOTER -->
    <footer class="bg-dark text-center py-4 mt-5">
        <div class="container">
            <p class="mb-0">&copy; 2024 Troya Imóveis. Todos os direitos reservados.</p>
            <p class="text-muted small mb-0">
                <a href="contato.php" class="text-white">Contato</a> | 
                <a href="privacidade.php" class="text-white">Privacidade</a>
            </p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
