<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contato - Troya Imóveis</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root { --primary: #238636; --dark: #0d1117; --darker: #161b22; --border: #30363d; --text: #e6edf3; }
        body { background: var(--dark); color: var(--text); }
        .contact-card { background: var(--darker); border: 1px solid var(--border); border-radius: 8px; padding: 2rem; }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="index.php">Troya Imóveis</a>
            <a href="index.php" class="btn btn-outline-light">← Imóveis</a>
        </div>
    </nav>

    <div class="container my-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <h1 class="text-center mb-4">Entre em Contato</h1>
                
                <div class="contact-card mb-4">
                    <h3><i class="bi bi-telephone me-2"></i>WhatsApp</h3>
                    <p>Envie sua mensagem diretamente para nossos corretores</p>
                    <a href="https://wa.me/5531991234567?text=Olá! Gostaria de mais informações sobre imóveis." 
                       class="btn btn-success btn-lg w-100">
                        <i class="bi bi-whatsapp me-2"></i>Iniciar Chat
                    </a>
                </div>

                <div class="contact-card mb-4">
                    <h3><i class="bi bi-telephone me-2"></i>Telefone</h3>
                    <p>(31) 99123-4567</p>
                    <a href="tel:+5531991234567" class="btn btn-outline-success w-100">Ligar Agora</a>
                </div>

                <div class="contact-card">
                    <h3><i class="bi bi-envelope me-2"></i>Email</h3>
                    <p>contato@troyaimoveis.com</p>
                    <a href="mailto:contato@troyaimoveis.com" class="btn btn-outline-primary w-100">Enviar Email</a>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-dark text-center py-4 mt-5">
        <div class="container">
            <p>&copy; 2024 Troya Imóveis. Todos os direitos reservados.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
