<?php
// app/alerts.php - contagem de atendimentos inativos para sino de alertas
require_once __DIR__ . '/db.php';
if (!defined('ALERT_INATIVOS_DIAS')) {
  // Ajuste depois para vir de config; valor padrão 3 dias
  define('ALERT_INATIVOS_DIAS', 3);
}
function alerts_overdue_count($days = null) {
  $days = (int)($days ?? ALERT_INATIVOS_DIAS);
  $row = fetch_one("
    SELECT COUNT(*) AS c
      FROM interactions
     WHERE status <> 'finalizado'
       AND (last_activity_at IS NULL OR last_activity_at <= DATE_SUB(NOW(), INTERVAL ? DAY))
  ", [$days], true);
  return (int)($row['c'] ?? 0);
}
