<?php
require_once __DIR__ . '/../app/rbac.php';
require_once __DIR__ . '/../app/alerts.php';
$BASE = defined('BASE_URL') ? BASE_URL : '';
$isMgr = rbac_can('admin','view') || rbac_can('admin','alerts') || rbac_is_admin();
$alertCount = $isMgr ? alerts_overdue_count() : 0;
?>
<!-- Dentro do <ul class="navbar-nav ms-auto"> -->
<?php if ($isMgr): ?>
  <li class="nav-item ms-2">
    <a class="nav-link position-relative" href="<?=$BASE?>/admin/alertas">
      <i class="bi bi-bell"></i>
      <?php if ($alertCount > 0): ?>
        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
          <?=$alertCount?>
        </span>
      <?php endif; ?>
    </a>
  </li>
<?php endif; ?>
