<?php
session_start();
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: login.php");
    exit;
}

require_once 'app/db.php';

$erro = '';
$sucesso = '';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $titulo = trim($_POST['titulo'] ?? '');
    $preco = parse_money($_POST['preco'] ?? '0');
    $tipo = trim($_POST['tipo'] ?? '');
    $finalidade = trim($_POST['finalidade'] ?? '');
    $cidade = trim($_POST['cidade'] ?? '');
    $uf = trim($_POST['uf'] ?? '');
    $bairro = trim($_POST['bairro'] ?? '');
    $endereco = trim($_POST['endereco'] ?? '');
    $cep = trim($_POST['cep'] ?? '');
    $quartos = (int)($_POST['quartos'] ?? 0);
    $banheiros = (int)($_POST['banheiros'] ?? 0);
    $vagas = (int)($_POST['vagas'] ?? 0);
    $area = (float)($_POST['area'] ?? 0);
    $status = trim($_POST['status'] ?? 'rascunho');
    $descricao = trim($_POST['descricao'] ?? '');

    if (empty($titulo)) {
        $erro = 'O título é obrigatório.';
    } elseif (empty($preco) || $preco <= 0) {
        $erro = 'O preço deve ser maior que zero.';
    } elseif (empty($tipo)) {
        $erro = 'O tipo é obrigatório.';
    } elseif (empty($finalidade)) {
        $erro = 'A finalidade é obrigatória.';
    } elseif (empty($cidade) || empty($uf)) {
        $erro = 'Cidade e estado são obrigatórios.';
    } else {
        try {
            $slug = strtolower(preg_replace('/[^a-z0-9]+/', '-', iconv('UTF-8', 'ASCII//TRANSLIT', $titulo)));
            $slug = trim($slug, '-') . '-' . time();
            
            $sql = "INSERT INTO properties (
                status, finalidade, tipo, titulo, slug, preco, quartos, banheiros, vagas, 
                cep, endereco, bairro, cidade, uf, area_construida_m2, descricao, 
                created_by, created_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";

            execute($sql, [
                $status, $finalidade, $tipo, $titulo, $slug, $preco, $quartos, $banheiros, $vagas,
                $cep, $endereco, $bairro, $cidade, $uf, $area, $descricao,
                $_SESSION['user_id'] ?? 1
            ]);
            
            $sucesso = 'Imóvel cadastrado com sucesso! <a href="imoveis.php" class="alert-link">Ver lista</a>';
            $_POST = [];
            
        } catch (Exception $e) {
            $erro = 'Erro ao cadastrar: ' . $e->getMessage();
        }
    }
}

$estados = ['AC','AL','AP','AM','BA','CE','DF','ES','GO','MA','MT','MS','MG','PA','PB','PR','PE','PI','RJ','RN','RS','RO','RR','SC','SP','SE','TO'];
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Novo Imóvel - Troya CRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --bg-dark: #0d1117;
            --bg-card: #161b22;
            --border: #30363d;
            --text: #e6edf3;
            --text-muted: #8b949e;
            --primary: #238636;
        }
        body { background: var(--bg-dark); color: var(--text); font-family: system-ui, sans-serif; }
        .navbar { background: var(--bg-card) !important; border-bottom: 1px solid var(--border); }
        .card { background: var(--bg-card); border: 1px solid var(--border); color: var(--text); }
        .form-control, .form-select, textarea { 
            background: #0d1117; 
            border: 1px solid var(--border); 
            color: var(--text); 
        }
        .form-control:focus, .form-select:focus, textarea:focus {
            background: #0d1117;
            border-color: var(--primary);
            color: var(--text);
            box-shadow: 0 0 0 0.2rem rgba(35, 134, 54, 0.25);
        }
        .form-control::placeholder { color: var(--text-muted); }
        .btn-primary { background: var(--primary); border-color: var(--primary); }
        .btn-primary:hover { background: #2ea043; }
        .text-muted { color: var(--text-muted) !important; }
        .form-section { border-bottom: 1px solid var(--border); margin-bottom: 2rem; padding-bottom: 2rem; }
        .form-section:last-child { border-bottom: none; }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark">
        <div class="container-fluid">
            <a class="navbar-brand fw-bold" href="imoveis.php">
                <i class="bi bi-arrow-left me-2"></i>Voltar para Imóveis
            </a>
            <div class="d-flex align-items-center gap-3">
                <span class="navbar-text"><?= sanitize($_SESSION["user_name"]) ?></span>
                <a href="logout.php" class="btn btn-outline-light btn-sm">Sair</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4 mb-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card">
                    <div class="card-header">
                        <h4 class="mb-0">
                            <i class="bi bi-house-plus me-2 text-success"></i>
                            Novo Imóvel
                        </h4>
                    </div>
                    
                    <div class="card-body">
                        <?php if ($sucesso): ?>
                            <div class="alert alert-success"><?= $sucesso ?></div>
                        <?php endif; ?>

                        <?php if ($erro): ?>
                            <div class="alert alert-danger">
                                <i class="bi bi-exclamation-triangle me-2"></i><?= sanitize($erro) ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST">
                            <!-- INFORMAÇÕES BÁSICAS -->
                            <div class="form-section">
                                <h5><i class="bi bi-info-circle me-2"></i>Informações Básicas</h5>
                                
                                <div class="row g-3">
                                    <div class="col-md-8">
                                        <label class="form-label">Título <span class="text-danger">*</span></label>
                                        <input type="text" name="titulo" class="form-control" 
                                               value="<?= sanitize($_POST['titulo'] ?? '') ?>" 
                                               placeholder="Ex: Casa 3 quartos no centro" required>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <label class="form-label">Status</label>
                                        <select name="status" class="form-select">
                                            <option value="rascunho">Rascunho</option>
                                            <option value="publicado">Publicado</option>
                                            <option value="vendido">Vendido</option>
                                            <option value="alugado">Alugado</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row g-3 mt-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Finalidade <span class="text-danger">*</span></label>
                                        <select name="finalidade" class="form-select" required>
                                            <option value="">Selecione...</option>
                                            <option value="venda">Venda</option>
                                            <option value="aluguel">Aluguel</option>
                                        </select>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label class="form-label">Tipo <span class="text-danger">*</span></label>
                                        <select name="tipo" class="form-select" required>
                                            <option value="">Selecione...</option>
                                            <option value="Casa">Casa</option>
                                            <option value="Apartamento">Apartamento</option>
                                            <option value="Kitnet">Kitnet</option>
                                            <option value="Terreno">Terreno</option>
                                            <option value="Comercial">Comercial</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- PREÇO -->
                            <div class="form-section">
                                <h5><i class="bi bi-currency-dollar me-2"></i>Preço e Características</h5>
                                
                                <div class="row g-3">
                                    <div class="col-md-4">
                                        <label class="form-label">Preço <span class="text-danger">*</span></label>
                                        <input type="text" name="preco" class="form-control" 
                                               placeholder="150000.00" required>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label class="form-label">Quartos</label>
                                        <input type="number" name="quartos" class="form-control" min="0" max="20">
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label class="form-label">Banheiros</label>
                                        <input type="number" name="banheiros" class="form-control" min="0" max="10">
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label class="form-label">Vagas</label>
                                        <input type="number" name="vagas" class="form-control" min="0" max="10">
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <label class="form-label">Área (m²)</label>
                                        <input type="number" name="area" class="form-control" step="0.01">
                                    </div>
                                </div>
                            </div>

                            <!-- LOCALIZAÇÃO -->
                            <div class="form-section">
                                <h5><i class="bi bi-geo-alt me-2"></i>Localização</h5>
                                
                                <div class="row g-3">
                                    <div class="col-md-3">
                                        <label class="form-label">CEP</label>
                                        <input type="text" name="cep" class="form-control" placeholder="12345-678">
                                    </div>
                                    
                                    <div class="col-md-5">
                                        <label class="form-label">Endereço</label>
                                        <input type="text" name="endereco" class="form-control" placeholder="Rua das Flores, 123">
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <label class="form-label">Bairro</label>
                                        <input type="text" name="bairro" class="form-control" placeholder="Centro">
                                    </div>
                                </div>

                                <div class="row g-3 mt-3">
                                    <div class="col-md-8">
                                        <label class="form-label">Cidade <span class="text-danger">*</span></label>
                                        <input type="text" name="cidade" class="form-control" required placeholder="Belo Horizonte">
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <label class="form-label">Estado <span class="text-danger">*</span></label>
                                        <select name="uf" class="form-select" required>
                                            <option value="">Selecione...</option>
                                            <?php foreach ($estados as $estado): ?>
                                                <option value="<?= $estado ?>"><?= $estado ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- DESCRIÇÃO -->
                            <div class="form-section">
                                <h5><i class="bi bi-card-text me-2"></i>Descrição</h5>
                                <textarea name="descricao" class="form-control" rows="6" 
                                          placeholder="Descreva as características do imóvel..."><?= sanitize($_POST['descricao'] ?? '') ?></textarea>
                            </div>

                            <!-- BOTÕES -->
                            <div class="d-flex gap-2 justify-content-end">
                                <a href="imoveis.php" class="btn btn-outline-secondary">
                                    <i class="bi bi-x me-1"></i>Cancelar
                                </a>
                                <button type="submit" class="btn btn-success">
                                    <i class="bi bi-check me-1"></i>Cadastrar Imóvel
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
