<?php
session_start();
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: login.php");
    exit;
}

require_once 'app/db.php';

// Estatísticas
$imoveis_publicados = 0;
$imoveis_total = 0;
$total_clientes = 0;
$ultimos_imoveis = [];
$ultimos_clientes = [];
$conexao_ok = true;
$erro_db = null;

try {
    // Teste de conexão
    db()->query("SELECT 1");
    
    // Contar imóveis
    $imoveis_publicados = count_properties('publicado');
    $imoveis_total = count_properties();
    
    // Contar clientes
    $total_clientes = count_clients();
    
    // Últimos imóveis
    $ultimos_imoveis = get_recent_properties(5);
    
    // Últimos clientes
    $ultimos_clientes = get_recent_clients(5);
    
} catch (Exception $e) {
    $conexao_ok = false;
    $erro_db = $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Troya CRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --bg-dark: #0d1117;
            --bg-card: #161b22;
            --bg-card-hover: #21262d;
            --border: #30363d;
            --text: #e6edf3;
            --text-muted: #8b949e;
            --text-secondary: #c9d1d9;
            --primary: #238636;
            --primary-hover: #2ea043;
            --success: #238636;
            --info: #58a6ff;
            --warning: #d29922;
            --danger: #f85149;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body { 
            background: var(--bg-dark); 
            color: var(--text); 
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Noto Sans", Helvetica, Arial, sans-serif;
            line-height: 1.6;
        }
        
        /* NAVBAR */
        .navbar { 
            background: var(--bg-card) !important; 
            border-bottom: 1px solid var(--border);
            padding: 1rem 0;
        }
        .navbar-brand {
            font-weight: 600;
            font-size: 1.25rem;
            color: var(--text) !important;
        }
        .navbar-text {
            color: var(--text-secondary) !important;
        }
        
        /* CARDS */
        .card { 
            background: var(--bg-card); 
            border: 1px solid var(--border); 
            color: var(--text);
            border-radius: 8px;
            overflow: hidden;
        }
        .card-header {
            background: var(--bg-card-hover) !important;
            border-bottom: 1px solid var(--border);
            padding: 1rem 1.25rem;
            font-weight: 600;
        }
        .card-body {
            padding: 1.25rem;
        }
        
        /* STAT CARDS */
        .stat-card { 
            transition: all 0.2s ease; 
            cursor: pointer;
            text-decoration: none;
            display: block;
            height: 100%;
        }
        .stat-card:hover { 
            transform: translateY(-4px); 
            box-shadow: 0 8px 25px rgba(0,0,0,0.4);
            border-color: var(--primary);
        }
        .stat-card .card-body {
            padding: 2rem 1.5rem;
        }
        .stat-card h2 {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--text);
            margin: 0.5rem 0;
        }
        .stat-card p {
            margin: 0;
            font-size: 0.95rem;
        }
        .stat-card small {
            font-size: 0.85rem;
            display: block;
            margin-top: 0.5rem;
        }
        
        /* BADGES */
        .badge {
            font-size: 0.75rem;
            font-weight: 600;
            padding: 0.35em 0.65em;
        }
        
        /* BUTTONS */
        .btn {
            border-radius: 6px;
            font-weight: 500;
            padding: 0.5rem 1rem;
            transition: all 0.2s;
        }
        .btn-primary { 
            background: var(--primary); 
            border-color: var(--primary);
            color: white;
        }
        .btn-primary:hover { 
            background: var(--primary-hover); 
            border-color: var(--primary-hover);
            color: white;
        }
        .btn-success {
            background: var(--success);
            border-color: var(--success);
        }
        .btn-success:hover {
            background: var(--primary-hover);
            border-color: var(--primary-hover);
        }
        .btn-outline-light:hover {
            background: rgba(255,255,255,0.1);
        }
        .btn-outline-primary {
            color: var(--info);
            border-color: var(--info);
        }
        .btn-outline-primary:hover {
            background: var(--info);
            border-color: var(--info);
            color: white;
        }
        .btn-outline-secondary {
            color: var(--text-muted);
            border-color: var(--border);
        }
        .btn-outline-secondary:hover {
            background: var(--bg-card-hover);
            border-color: var(--text-muted);
            color: var(--text);
        }
        
        /* TABLES */
        .table-dark {
            --bs-table-bg: transparent;
            --bs-table-border-color: var(--border);
            color: var(--text);
        }
        .table-dark th {
            background: var(--bg-card-hover);
            border-color: var(--border);
            font-weight: 600;
            color: var(--text-secondary);
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            padding: 1rem;
        }
        .table-dark td {
            border-color: var(--border);
            vertical-align: middle;
            padding: 1rem;
        }
        .table-hover tbody tr:hover {
            background: var(--bg-card-hover);
        }
        
        /* LIST GROUP */
        .list-group-item { 
            background: transparent; 
            border-color: var(--border); 
            color: var(--text);
            padding: 1rem 1.25rem;
        }
        .list-group-item:hover {
            background: var(--bg-card-hover);
        }
        
        /* EMPTY STATE */
        .empty-state { 
            text-align: center; 
            padding: 3rem 1.5rem;
        }
        .empty-state i { 
            color: var(--text-muted);
            font-size: 4rem; 
            margin-bottom: 1.5rem;
            display: block;
            opacity: 0.5;
        }
        .empty-state h5 {
            color: var(--text-secondary);
            margin-bottom: 0.75rem;
            font-weight: 600;
        }
        .empty-state p {
            color: var(--text-muted);
            margin-bottom: 1.5rem;
        }
        
        /* TEXT COLORS */
        .text-muted {
            color: var(--text-muted) !important;
        }
        .text-secondary {
            color: var(--text-secondary) !important;
        }
        small, .small {
            color: var(--text-muted) !important;
            font-size: 0.875rem;
        }
        
        /* ALERTS */
        .alert {
            border-radius: 6px;
            border: 1px solid;
        }
        .alert-danger {
            background: rgba(248, 81, 73, 0.1);
            border-color: var(--danger);
            color: var(--text);
        }
        .alert-success {
            background: rgba(35, 134, 54, 0.1);
            border-color: var(--success);
            color: var(--text);
        }
        
        /* LINKS */
        a {
            color: var(--info);
            text-decoration: none;
            transition: color 0.2s;
        }
        a:hover {
            color: #79c0ff;
        }
        
        /* UTILITY CLASSES */
        .text-success {
            color: var(--success) !important;
        }
        .text-primary {
            color: var(--info) !important;
        }
        .text-info {
            color: var(--info) !important;
        }
        .text-warning {
            color: var(--warning) !important;
        }
        .text-danger {
            color: var(--danger) !important;
        }
        .bg-success {
            background-color: var(--success) !important;
        }
        .bg-primary {
            background-color: var(--info) !important;
        }
        .bg-info {
            background-color: var(--info) !important;
        }
        .bg-warning {
            background-color: var(--warning) !important;
        }
        .bg-danger {
            background-color: var(--danger) !important;
        }
        
        /* PRÓXIMOS PASSOS */
        .next-steps-item {
            padding: 1rem;
            border-radius: 6px;
            transition: background 0.2s;
        }
        .next-steps-item:hover {
            background: var(--bg-card-hover);
        }
        .next-steps-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
        }
        
        /* RESPONSIVIDADE */
        @media (max-width: 768px) {
            .stat-card h2 {
                font-size: 2rem;
            }
            .empty-state {
                padding: 2rem 1rem;
            }
            .empty-state i {
                font-size: 3rem;
            }
            .card-body {
                padding: 1rem;
            }
            .table-responsive {
                font-size: 0.875rem;
            }
        }
        
        /* ANIMAÇÕES */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        .card {
            animation: fadeIn 0.3s ease-out;
        }
    </style>
</head>
<body>
    <!-- NAVBAR -->
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container-fluid">
            <a class="navbar-brand fw-bold" href="dashboard.php">
                <i class="bi bi-house-door-fill me-2"></i>Troya CRM
            </a>
            
            <div class="navbar-nav ms-auto d-flex flex-row align-items-center gap-3">
                <span class="navbar-text">
                    <i class="bi bi-person-circle me-1"></i>
                    <?= sanitize($_SESSION["user_name"]) ?>
                </span>
                <a href="logout.php" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-box-arrow-right me-1"></i>Sair
                </a>
            </div>
        </div>
    </nav>

    <div class="container mt-4 mb-5">
        <!-- HEADER -->
        <div class="d-flex justify-content-between align-items-center mb-4 flex-wrap gap-3">
            <div>
                <h1 class="mb-1 fw-bold">
                    <i class="bi bi-speedometer2 me-2"></i>Dashboard
                </h1>
                <p class="text-muted mb-0">Bem-vindo de volta, <?= sanitize($_SESSION["user_name"]) ?>!</p>
            </div>
            
            <div class="d-flex align-items-center gap-2 flex-wrap">
                <?php if ($conexao_ok): ?>
                    <span class="badge bg-success fs-6 px-3 py-2">
                        <i class="bi bi-check-circle-fill me-1"></i>
                        Banco Conectado
                    </span>
                <?php else: ?>
                    <span class="badge bg-danger fs-6 px-3 py-2">
                        <i class="bi bi-x-circle-fill me-1"></i>
                        Erro de Banco
                    </span>
                <?php endif; ?>
                
                <a href="teste_conexao.php" class="btn btn-outline-secondary btn-sm">
                    <i class="bi bi-plug me-1"></i>Testar Conexão
                </a>
            </div>
        </div>

        <?php if ($erro_db): ?>
            <div class="alert alert-danger mb-4">
                <h5 class="mb-2"><i class="bi bi-exclamation-triangle-fill me-2"></i>Erro de Conexão</h5>
                <p class="mb-3"><?= sanitize($erro_db) ?></p>
                <div class="d-flex gap-2">
                    <a href="config/config.php" class="btn btn-sm btn-warning">Editar Config</a>
                    <a href="teste_conexao.php" class="btn btn-sm btn-outline-secondary">Testar Novamente</a>
                </div>
            </div>
        <?php endif; ?>

        <!-- ESTATÍSTICAS -->
        <div class="row g-4 mb-5">
            <div class="col-lg-3 col-md-6">
                <a href="imoveis.php" class="stat-card card">
                    <div class="card-body text-center">
                        <i class="bi bi-building display-4 text-success"></i>
                        <h2 class="mt-3 mb-1"><?= $imoveis_publicados ?></h2>
                        <p class="text-muted mb-0">Imóveis Publicados</p>
                        <small class="text-success fw-semibold">
                            <?= $imoveis_total - $imoveis_publicados ?> em rascunho
                        </small>
                    </div>
                </a>
            </div>

            <div class="col-lg-3 col-md-6">
                <a href="clientes.php" class="stat-card card">
                    <div class="card-body text-center">
                        <i class="bi bi-people display-4 text-primary"></i>
                        <h2 class="mt-3 mb-1"><?= $total_clientes ?></h2>
                        <p class="text-muted mb-0">Total de Clientes</p>
                        <small class="text-primary fw-semibold">
                            Cadastrados no sistema
                        </small>
                    </div>
                </a>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="stat-card card">
                    <div class="card-body text-center">
                        <i class="bi bi-calendar-check display-4 text-info"></i>
                        <h2 class="mt-3 mb-1">0</h2>
                        <p class="text-muted mb-0">Visitas Agendadas</p>
                        <small class="text-info fw-semibold">
                            Em breve disponível
                        </small>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6">
                <div class="stat-card card">
                    <div class="card-body text-center">
                        <i class="bi bi-graph-up display-4 text-warning"></i>
                        <h2 class="mt-3 mb-1">0</h2>
                        <p class="text-muted mb-0">Propostas</p>
                        <small class="text-warning fw-semibold">
                            Em breve disponível
                        </small>
                    </div>
                </div>
            </div>
        </div>

        <?php if ($conexao_ok): ?>
            <!-- RECENTES -->
            <div class="row g-4">
                <!-- ÚLTIMOS IMÓVEIS -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class="bi bi-house-door me-2 text-success"></i>
                                Últimos Imóveis
                            </h5>
                            <a href="imoveis.php" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-grid me-1"></i>Ver Todos
                            </a>
                        </div>
                        
                        <div class="card-body p-0">
                            <?php if (empty($ultimos_imoveis)): ?>
                                <div class="empty-state">
                                    <i class="bi bi-house-door"></i>
                                    <h5>Nenhum imóvel cadastrado</h5>
                                    <p>Comece adicionando seu primeiro imóvel ao sistema!</p>
                                    <a href="imovel_criar.php" class="btn btn-success">
                                        <i class="bi bi-plus-circle me-2"></i>Cadastrar Imóvel
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="table-responsive">
                                    <table class="table table-dark table-hover mb-0">
                                        <thead>
                                            <tr>
                                                <th>Título</th>
                                                <th>Preço</th>
                                                <th>Cidade</th>
                                                <th>Status</th>
                                                <th>Data</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($ultimos_imoveis as $imovel): ?>
                                            <tr>
                                                <td>
                                                    <strong><?= sanitize($imovel['titulo']) ?></strong>
                                                    <?php if ($imovel['status'] === 'rascunho'): ?>
                                                        <span class="badge bg-warning text-dark ms-2">Rascunho</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <span class="text-success fw-bold">
                                                        <?= format_money($imovel['preco']) ?>
                                                    </span>
                                                </td>
                                                <td><?= sanitize($imovel['cidade']) ?></td>
                                                <td>
                                                    <span class="badge <?= $imovel['status'] === 'publicado' ? 'bg-success' : 'bg-secondary' ?>">
                                                        <?= ucfirst($imovel['status']) ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <small class="text-muted">
                                                        <?= date('d/m/Y', strtotime($imovel['created_at'])) ?>
                                                    </small>
                                                </td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- ÚLTIMOS CLIENTES -->
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class="bi bi-people me-2 text-primary"></i>
                                Últimos Clientes
                            </h5>
                            <a href="clientes.php" class="btn btn-sm btn-outline-primary">
                                <i class="bi bi-people me-1"></i>Ver Todos
                            </a>
                        </div>
                        
                        <div class="card-body p-0">
                            <?php if (empty($ultimos_clientes)): ?>
                                <div class="empty-state">
                                    <i class="bi bi-person-plus"></i>
                                    <h5>Nenhum cliente cadastrado</h5>
                                    <p>Adicione seu primeiro cliente para começar!</p>
                                    <a href="cliente_criar.php" class="btn btn-success">
                                        <i class="bi bi-plus-circle me-2"></i>Cadastrar Cliente
                                    </a>
                                </div>
                            <?php else: ?>
                                <ul class="list-group list-group-flush">
                                    <?php foreach ($ultimos_clientes as $cliente): ?>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <div>
                                            <strong><?= sanitize($cliente['nome']) ?></strong>
                                            <?php if ($cliente['email']): ?>
                                                <br><small><?= sanitize($cliente['email']) ?></small>
                                            <?php endif; ?>
                                        </div>
                                        <?php if ($cliente['whatsapp']): ?>
                                            <a href="https://wa.me/55<?= preg_replace('/\D/', '', $cliente['whatsapp']) ?>" 
                                               class="btn btn-sm btn-success" target="_blank" title="WhatsApp">
                                                <i class="bi bi-whatsapp"></i>
                                            </a>
                                        <?php endif; ?>
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- PRÓXIMOS PASSOS -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="bi bi-lightbulb me-2 text-warning"></i>
                                Próximos Passos
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-4">
                                    <div class="next-steps-item">
                                        <div class="d-flex align-items-center">
                                            <div class="next-steps-icon bg-success text-white me-3">
                                                <i class="bi bi-check-lg"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-1 fw-semibold">Conexão OK</h6>
                                                <small>Banco de dados conectado com sucesso</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="next-steps-item">
                                        <div class="d-flex align-items-center">
                                            <div class="next-steps-icon bg-warning text-white me-3">
                                                <i class="bi bi-plus-circle"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-1 fw-semibold">Adicionar Conteúdo</h6>
                                                <small>Cadastre imóveis e clientes</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="next-steps-item">
                                        <div class="d-flex align-items-center">
                                            <div class="next-steps-icon bg-info text-white me-3">
                                                <i class="bi bi-gear"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-1 fw-semibold">Configurar Site</h6>
                                                <small>Integre com troyasite</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <!-- INSTRUÇÕES DE INSTALAÇÃO -->
            <div class="alert alert-success">
                <h5><i class="bi bi-check-circle me-2"></i>Troya CRM instalado com sucesso!</h5>
                <p class="mb-2">Complete a instalação seguindo estes passos:</p>
                <ol class="mb-0">
                    <li>Configure <code>config/config.php</code> com suas credenciais MySQL</li>
                    <li>Importe <code>database.sql</code> no phpMyAdmin</li>
                    <li>Atualize esta página</li>
                </ol>
            </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
