<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: /troyacrm/login");
    exit;
}

require_once __DIR__ . '/../../app/db.php';

// Pegar ID do imóvel
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id <= 0) {
    header("Location: " . BASE_URL . "/imoveis");
    exit;
}

// Buscar dados do imóvel
try {
    $imovel = fetch_one("SELECT * FROM properties WHERE id = ?", [$id], true);
    
    if (!$imovel) {
        header("Location: " . BASE_URL . "/imoveis");
        exit;
    }
    
    // Buscar fotos do imóvel
    $fotos = fetch_all("SELECT * FROM property_photos WHERE property_id = ? ORDER BY ordem ASC", [$id], true);
    
} catch (Exception $e) {
    die("Erro ao carregar imóvel: " . $e->getMessage());
}

$page_title = 'Visualizar: ' . $imovel['titulo'];
include __DIR__ . '/../../layout/header.php';
?>

<style>
/* Estilos específicos para a visualização */
.preview-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
}

.preview-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 30px;
    border-radius: 15px;
    margin-bottom: 30px;
    position: relative;
}

.preview-badge {
    position: absolute;
    top: 20px;
    right: 20px;
}

.preview-price {
    font-size: 2.5rem;
    font-weight: bold;
    margin: 10px 0;
}

.preview-location {
    font-size: 1.2rem;
    opacity: 0.9;
}

.photo-carousel {
    border-radius: 15px;
    overflow: hidden;
    margin-bottom: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.3);
}

.photo-carousel img {
    width: 100%;
    height: 500px;
    object-fit: cover;
}

.no-photos-placeholder {
    background: linear-gradient(135deg, #434343 0%, #000000 100%);
    height: 500px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-direction: column;
    color: #adb5bd;
    border-radius: 15px;
    margin-bottom: 30px;
}

.no-photos-placeholder i {
    font-size: 5rem;
    margin-bottom: 20px;
    opacity: 0.5;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin: 30px 0;
}

.feature-card {
    background: var(--bs-dark);
    padding: 20px;
    border-radius: 10px;
    text-align: center;
    border: 1px solid rgba(255,255,255,0.1);
}

.feature-icon {
    font-size: 2rem;
    margin-bottom: 10px;
    color: #28a745;
}

.feature-label {
    font-size: 0.9rem;
    color: #adb5bd;
    margin-bottom: 5px;
}

.feature-value {
    font-size: 1.5rem;
    font-weight: bold;
}

.description-section {
    background: var(--bs-dark);
    padding: 30px;
    border-radius: 15px;
    margin: 30px 0;
}

.admin-toolbar {
    position: fixed;
    bottom: 20px;
    right: 20px;
    z-index: 1000;
}
</style>

<div class="preview-container">
    <!-- Header com título e preço -->
    <div class="preview-header">
        <span class="preview-badge badge bg-<?=$imovel['status'] == 'publicado' ? 'success' : 'warning'?>">
            <?=ucfirst($imovel['status'])?>
        </span>
        
        <h1 class="mb-2"><?=htmlspecialchars($imovel['titulo'])?></h1>
        
        <div class="preview-location">
            <i class="bi bi-geo-alt-fill me-2"></i>
            <?=htmlspecialchars($imovel['endereco'])?> - <?=htmlspecialchars($imovel['bairro'])?>, 
            <?=htmlspecialchars($imovel['cidade'])?>/<?=strtoupper($imovel['uf'])?>
        </div>
        
        <div class="preview-price">
            <?=format_money($imovel['preco'])?>
        </div>
        
        <div>
            <span class="badge bg-light text-dark me-2">
                <?=ucfirst($imovel['finalidade'] ?? 'Venda')?>
            </span>
            <span class="badge bg-light text-dark">
                <?=ucfirst($imovel['tipo'] ?? 'Imóvel')?>
            </span>
        </div>
    </div>

    <!-- Carrossel de fotos -->
    <?php if (!empty($fotos)): ?>
    <div id="photoCarousel" class="carousel slide photo-carousel" data-bs-ride="carousel">
        <div class="carousel-indicators">
            <?php foreach ($fotos as $index => $foto): ?>
            <button type="button" data-bs-target="#photoCarousel" data-bs-slide-to="<?=$index?>" 
                    class="<?=$index === 0 ? 'active' : ''?>" 
                    aria-label="Foto <?=$index + 1?>"></button>
            <?php endforeach; ?>
        </div>
        
        <div class="carousel-inner">
            <?php foreach ($fotos as $index => $foto): ?>
            <div class="carousel-item <?=$index === 0 ? 'active' : ''?>">
                <img src="<?=BASE_URL?>/uploads/imoveis/<?=$imovel['id']?>/<?=$foto['filename']?>" 
                     alt="<?=htmlspecialchars($imovel['titulo'])?>"
                     onerror="this.src='<?=BASE_URL?>/assets/img/no-image.jpg'">
            </div>
            <?php endforeach; ?>
        </div>
        
        <button class="carousel-control-prev" type="button" data-bs-target="#photoCarousel" data-bs-slide="prev">
            <span class="carousel-control-prev-icon"></span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#photoCarousel" data-bs-slide="next">
            <span class="carousel-control-next-icon"></span>
        </button>
    </div>
    <?php else: ?>
    <div class="no-photos-placeholder">
        <i class="bi bi-image"></i>
        <h3>Nenhuma foto cadastrada</h3>
        <p class="mb-0">Adicione fotos para deixar o anúncio mais atrativo</p>
    </div>
    <?php endif; ?>

    <!-- Grade de características -->
    <div class="features-grid">
        <?php if ($imovel['quartos']): ?>
        <div class="feature-card">
            <div class="feature-icon"><i class="bi bi-door-closed"></i></div>
            <div class="feature-label">Quartos</div>
            <div class="feature-value"><?=$imovel['quartos']?></div>
        </div>
        <?php endif; ?>
        
        <?php if ($imovel['suites']): ?>
        <div class="feature-card">
            <div class="feature-icon"><i class="bi bi-star-fill"></i></div>
            <div class="feature-label">Suítes</div>
            <div class="feature-value"><?=$imovel['suites']?></div>
        </div>
        <?php endif; ?>
        
        <?php if ($imovel['banheiros']): ?>
        <div class="feature-card">
            <div class="feature-icon"><i class="bi bi-droplet-fill"></i></div>
            <div class="feature-label">Banheiros</div>
            <div class="feature-value"><?=$imovel['banheiros']?></div>
        </div>
        <?php endif; ?>
        
        <?php if ($imovel['vagas']): ?>
        <div class="feature-card">
            <div class="feature-icon"><i class="bi bi-car-front-fill"></i></div>
            <div class="feature-label">Vagas</div>
            <div class="feature-value"><?=$imovel['vagas']?></div>
        </div>
        <?php endif; ?>
        
        <?php if ($imovel['area_construida_m2']): ?>
        <div class="feature-card">
            <div class="feature-icon"><i class="bi bi-rulers"></i></div>
            <div class="feature-label">Área Construída</div>
            <div class="feature-value"><?=number_format($imovel['area_construida_m2'], 0, ',', '.')?> m²</div>
        </div>
        <?php endif; ?>
        
        <?php if ($imovel['area_terreno_m2']): ?>
        <div class="feature-card">
            <div class="feature-icon"><i class="bi bi-bounding-box"></i></div>
            <div class="feature-label">Área do Terreno</div>
            <div class="feature-value"><?=number_format($imovel['area_terreno_m2'], 0, ',', '.')?> m²</div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Descrição -->
    <?php if ($imovel['descricao']): ?>
    <div class="description-section">
        <h3 class="mb-4"><i class="bi bi-file-text me-2"></i>Descrição do Imóvel</h3>
        <div style="white-space: pre-wrap; line-height: 1.8;">
            <?=nl2br(htmlspecialchars($imovel['descricao']))?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Informações adicionais -->
    <div class="row g-4 mt-3">
        <div class="col-md-6">
            <div class="card bg-dark">
                <div class="card-body">
                    <h5 class="card-title"><i class="bi bi-info-circle me-2"></i>Informações</h5>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <strong>Código:</strong> #<?=$imovel['id']?>
                        </li>
                        <li class="mb-2">
                            <strong>Finalidade:</strong> <?=ucfirst($imovel['finalidade'] ?? 'Venda')?>
                        </li>
                        <li class="mb-2">
                            <strong>Tipo:</strong> <?=ucfirst($imovel['tipo'] ?? 'Imóvel')?>
                        </li>
                        <li class="mb-2">
                            <strong>CEP:</strong> <?=$imovel['cep'] ? htmlspecialchars($imovel['cep']) : 'Não informado'?>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card bg-dark">
                <div class="card-body">
                    <h5 class="card-title"><i class="bi bi-calendar-check me-2"></i>Cadastro</h5>
                    <ul class="list-unstyled mb-0">
                        <li class="mb-2">
                            <strong>Cadastrado em:</strong> <?=format_datetime($imovel['created_at'])?>
                        </li>
                        <li class="mb-2">
                            <strong>Status:</strong> 
                            <span class="badge bg-<?=$imovel['status'] == 'publicado' ? 'success' : 'warning'?>">
                                <?=ucfirst($imovel['status'])?>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Barra de ferramentas do admin (fixa no canto) -->
<div class="admin-toolbar">
    <div class="btn-group-vertical shadow-lg">
        <a href="<?=BASE_URL?>/imoveis/<?=$imovel['id']?>/editar" 
           class="btn btn-primary" 
           title="Editar imóvel">
            <i class="bi bi-pencil me-2"></i>Editar
        </a>
        <a href="<?=BASE_URL?>/imoveis/<?=$imovel['id']?>/fotos" 
           class="btn btn-info" 
           title="Gerenciar fotos">
            <i class="bi bi-images me-2"></i>Fotos
        </a>
        <a href="<?=BASE_URL?>/imoveis" 
           class="btn btn-secondary" 
           title="Voltar para listagem">
            <i class="bi bi-arrow-left me-2"></i>Voltar
        </a>
    </div>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
