<?php
require_once __DIR__ . '/../../app/db.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

// título e aba ativa (usados pelo layout/nav)
$page_title = 'Novo compromisso';
$active     = 'agenda';

// PDO resiliente
$__pdo = null;
if (function_exists('db')) { $__pdo = db(); }
elseif (isset($pdo) && $pdo instanceof PDO) { $__pdo = $pdo; }
elseif (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) { $__pdo = $GLOBALS['pdo']; }
else { throw new RuntimeException('Conexão PDO não encontrada.'); }

function q_all($sql,$p=[]){ global $__pdo;$st=$__pdo->prepare($sql);$st->execute($p);return $st->fetchAll(PDO::FETCH_ASSOC); }
function q_exec($sql,$p=[]){ global $__pdo;$st=$__pdo->prepare($sql);return $st->execute($p); }
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

// ---------- PROCESSA POST ANTES DO HEADER (para permitir redirect) ----------
$errors = [];
$titulo = trim($_POST['titulo'] ?? '');
$inicio = trim($_POST['inicio'] ?? '');
$fim    = trim($_POST['fim'] ?? '');
$property_id = (isset($_POST['property_id']) && $_POST['property_id']!=='') ? (int)$_POST['property_id'] : null;
$client_id   = (isset($_POST['client_id'])   && $_POST['client_id']  !=='') ? (int)$_POST['client_id']   : null;
$obs    = trim($_POST['obs'] ?? '');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if ($titulo === '') $errors[] = 'Informe o título';
  if ($inicio === '') $errors[] = 'Informe a data/hora inicial';
  if (!$errors) {
    q_exec(
      "INSERT INTO agenda (titulo,inicio,fim,property_id,client_id,obs,created_at) VALUES (?,?,?,?,?,?,NOW())",
      [$titulo, $inicio, ($fim?:null), $property_id, $client_id, ($obs?:null)]
    );
    header("Location: {$BASE}/modules/agenda/index.php");
    exit;
  }
}

// Carrega selects (somente após POST/validação)
$clientes = q_all("SELECT id, nome_completo AS nome FROM clients ORDER BY nome_completo ASC");
$imoveis  = q_all("SELECT id, titulo, cidade, uf FROM properties ORDER BY id DESC");

// ---------- LAYOUT PADRÃO ----------
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">

  <!-- Cabeçalho da página (padrão das outras telas) -->
  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-calendar2-week" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">Novo compromisso</h1>
      </div>
      <div class="text-muted small mt-1">Defina título, datas e relacione a um imóvel e/ou cliente</div>
    </div>
    <div class="d-flex gap-2">
      <a href="<?= $BASE ?>/modules/agenda/index.php" class="btn btn-outline-secondary">
        <i class="bi bi-list-ul"></i> Voltar à lista
      </a>
      <a href="<?= $BASE ?>/modules/agenda/calendario.php" class="btn btn-outline-secondary">
        <i class="bi bi-calendar3"></i> Calendário
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Novo compromisso</div>
    <div class="card-body">
      <?php if ($errors): ?>
        <div class="alert alert-danger">
          <?php foreach ($errors as $e) echo '<div>'.h($e).'</div>'; ?>
        </div>
      <?php endif; ?>

      <form method="post" autocomplete="off">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Título <span class="text-danger">*</span></label>
            <input type="text" name="titulo" class="form-control" value="<?= h($titulo) ?>" placeholder="Ex.: Visita ao imóvel" required>
          </div>

          <div class="col-md-3">
            <label class="form-label">Início <span class="text-danger">*</span></label>
            <input type="datetime-local" name="inicio" class="form-control" value="<?= h($inicio) ?>" required>
          </div>

          <div class="col-md-3">
            <label class="form-label">Fim</label>
            <input type="datetime-local" name="fim" class="form-control" value="<?= h($fim) ?>">
          </div>

          <div class="col-md-6">
            <label class="form-label">Imóvel (casa)</label>
            <select name="property_id" class="form-select">
              <option value="">— Selecionar (opcional) —</option>
              <?php foreach ($imoveis as $p):
                $rotulo = trim(($p['titulo'].' - '.trim(($p['cidade'].'/'.$p['uf']), '/')));
                $rotulo = $rotulo ?: ('Imóvel #'.(int)$p['id']);
              ?>
                <option value="<?= (int)$p['id'] ?>" <?= ($property_id===(int)$p['id'])?'selected':'' ?>>
                  <?= h($rotulo) ?>
                </option>
              <?php endforeach; ?>
            </select>
            <small class="text-muted">Opcional — o compromisso pode ser apenas com cliente, ou apenas interno.</small>
          </div>

          <div class="col-md-6">
            <label class="form-label">Cliente (opcional)</label>
            <select name="client_id" class="form-select">
              <option value="">— Selecionar (opcional) —</option>
              <?php foreach ($clientes as $c): ?>
                <option value="<?= (int)$c['id'] ?>" <?= ($client_id===(int)$c['id'])?'selected':'' ?>>
                  <?= h($c['nome']) ?>
                </option>
              <?php endforeach; ?>
            </select>
            <small class="text-muted">Se não quiser vincular a um cliente, deixe em branco.</small>
          </div>

          <div class="col-12">
            <label class="form-label">Observações</label>
            <textarea name="obs" class="form-control" rows="4" placeholder="Anote qualquer detalhe importante"><?= h($obs) ?></textarea>
          </div>
        </div>

        <div class="mt-4 d-flex gap-2">
          <button class="btn btn-primary">
            <i class="bi bi-check2"></i> Salvar
          </button>
          <a href="<?= $BASE ?>/modules/agenda/index.php" class="btn btn-outline-secondary">
            Cancelar
          </a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>