<?php
require_once __DIR__ . '/../../app/db.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

// título da página e aba ativa do menu
$page_title = 'Agenda';
$active = 'agenda';

// PDO compatível com seu app/db.php
$__pdo = null;
if (function_exists('db')) { $__pdo = db(); }
elseif (isset($pdo) && $pdo instanceof PDO) { $__pdo = $pdo; }
elseif (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) { $__pdo = $GLOBALS['pdo']; }
else { throw new RuntimeException('Conexão PDO não encontrada.'); }

function q_all($sql,$p=[]){ global $__pdo; $st=$__pdo->prepare($sql); $st->execute($p); return $st->fetchAll(PDO::FETCH_ASSOC); }
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

// Carrega itens da agenda
try {
  $rows = q_all("
    SELECT a.id, a.titulo, a.inicio, a.fim, a.property_id, a.client_id, a.obs,
           p.titulo AS p_titulo, p.cidade AS p_cidade, p.uf AS p_uf,
           c.nome_completo AS c_nome
      FROM agenda a
 LEFT JOIN properties p ON p.id = a.property_id
 LEFT JOIN clients    c ON c.id = a.client_id
  ORDER BY a.inicio DESC
     LIMIT 200
  ");
} catch (Throwable $e) {
  $rows = [];
  $load_error = $e->getMessage();
}

$total = count($rows);
$hoje = 0; $prox7 = 0;
$now = new DateTime(); $today = $now->format('Y-m-d'); $limite = (clone $now)->modify('+7 days');
foreach ($rows as $r) {
  $dt = DateTime::createFromFormat('Y-m-d H:i:s', $r['inicio']);
  if ($dt) {
    if ($dt->format('Y-m-d') === $today) $hoje++;
    if ($dt >= $now && $dt <= $limite) $prox7++;
  }
}

// header + navbar padrão do sistema
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">

  <!-- Cabeçalho da página (mesmo padrão das outras telas) -->
  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-calendar2-week" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">
          Agenda
          <span class="badge text-bg-secondary ms-2"><?php echo (int)$total; ?></span>
        </h1>
      </div>
      <div class="text-muted small mt-1">Organize seus compromissos e visitas</div>
    </div>
    <div class="d-flex gap-2">
      <a href="<?php echo $BASE; ?>/modules/agenda/novo.php" class="btn btn-success">
        <i class="bi bi-plus-lg"></i> Novo compromisso
      </a>
      <a href="<?php echo $BASE; ?>/modules/agenda/calendario.php" class="btn btn-outline-secondary">
        <i class="bi bi-calendar3"></i> Calendário
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Compromissos</div>
    <div class="card-body">
      <?php if (!empty($load_error)): ?>
        <div class="alert alert-danger"><strong>Erro:</strong> <?php echo h($load_error); ?></div>
      <?php endif; ?>

      <?php if (!$rows): ?>
        <div class="empty-state">
          <i class="bi bi-calendar4-week"></i>
          <h5>Nenhum compromisso</h5>
          <p>Crie o primeiro para começar a organizar sua agenda.</p>
          <a href="<?php echo $BASE; ?>/modules/agenda/novo.php" class="btn btn-success">
            <i class="bi bi-plus-lg"></i> Novo compromisso
          </a>
        </div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-dark table-hover align-middle mb-0">
            <thead>
              <tr>
                <th style="width:64px">ID</th>
                <th>Título</th>
                <th class="d-none d-sm-table-cell" style="width:160px">Início</th>
                <th class="d-none d-lg-table-cell" style="width:160px">Fim</th>
                <th class="d-none d-lg-table-cell">Imóvel (casa)</th>
                <th class="d-none d-xl-table-cell">Cliente</th>
                <th class="d-none d-xl-table-cell" style="min-width:220px">Observações</th>
                <th class="text-end" style="width:120px">Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rows as $r):
                $imovel  = $r['p_titulo'] ? ($r['p_titulo'].' - '.trim(($r['p_cidade'].'/'.$r['p_uf']), '/')) : '-';
                $cliente = $r['c_nome'] ?: '-';
                $obs     = trim((string)($r['obs'] ?? ''));
              ?>
              <tr>
                <td><?php echo (int)$r['id']; ?></td>
                <td>
                  <div class="fw-semibold text-truncate" style="max-width: 260px" title="<?php echo h($r['titulo']); ?>">
                    <?php echo h($r['titulo']); ?>
                  </div>
                  <div class="small text-muted d-sm-none">
                    <?php echo h(date('d/m/Y H:i', strtotime($r['inicio']))); ?>
                  </div>
                </td>
                <td class="d-none d-sm-table-cell"><?php echo h(date('d/m/Y H:i', strtotime($r['inicio']))); ?></td>
                <td class="d-none d-lg-table-cell"><?php echo $r['fim'] ? h(date('d/m/Y H:i', strtotime($r['fim']))) : '-'; ?></td>
                <td class="d-none d-lg-table-cell">
                  <div class="text-truncate" style="max-width: 240px" title="<?php echo h($imovel); ?>"><?php echo h($imovel); ?></div>
                </td>
                <td class="d-none d-xl-table-cell">
                  <div class="text-truncate" style="max-width: 220px" title="<?php echo h($cliente); ?>"><?php echo h($cliente); ?></div>
                </td>
                <td class="d-none d-xl-table-cell">
                  <?php if ($obs): ?>
                    <div class="text-truncate" style="max-width: 280px" title="<?php echo h($obs); ?>"><?php echo h($obs); ?></div>
                  <?php else: ?>
                    <span class="text-muted">—</span>
                  <?php endif; ?>
                </td>
                <td class="text-end">
                  <div class="btn-group">
                    <a class="btn btn-sm btn-outline-secondary" href="<?php echo $BASE; ?>/modules/agenda/editar.php?id=<?php echo (int)$r['id']; ?>" title="Editar"><i class="bi bi-pencil"></i></a>
                    <a class="btn btn-sm btn-outline-danger" href="<?php echo $BASE; ?>/modules/agenda/remover.php?id=<?php echo (int)$r['id']; ?>" onclick="return confirm('Remover compromisso?');" title="Excluir"><i class="bi bi-trash"></i></a>
                  </div>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>

    <div class="px-3 py-2 border-top" style="border-color: var(--border);">
      <div class="d-flex flex-wrap justify-content-between align-items-center gap-2 small">
        <div class="text-muted">
          <i class="bi bi-info-circle"></i>
          Total: <strong><?php echo (int)$total; ?></strong> compromisso<?php echo $total==1?'':'s'; ?>
        </div>
        <div class="d-flex gap-2">
          <span class="badge text-bg-success">Hoje: <?php echo (int)$hoje; ?></span>
          <span class="badge text-bg-primary">Próx. 7 dias: <?php echo (int)$prox7; ?></span>
        </div>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>