<?php
require_once __DIR__ . '/../../app/db.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

// título e aba ativa
$page_title = 'Agenda - Calendário';
$active = 'agenda';

// injeta FullCalendar pelo $extra_js (seu footer imprime)
ob_start(); ?>
<script>
(function(){
  var l=document.createElement('link');
  l.rel='stylesheet';
  l.href='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.css';
  document.head.appendChild(l);
}());
</script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/index.global.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.11/locales-all.global.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  var el = document.getElementById('calendar');
  var isMobile = window.matchMedia('(max-width: 767.98px)').matches;

  var calendar = new FullCalendar.Calendar(el, {
    initialView: isMobile ? 'listWeek' : 'dayGridMonth',
    locale: 'pt-br',
    height: 'auto',
    expandRows: true,
    handleWindowResize: true,
    nowIndicator: true,
    headerToolbar: { start: 'prev,next today', center: 'title', end: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek' },
    eventTimeFormat: { hour: '2-digit', minute: '2-digit', hour12: false },
    events: '<?= (defined("BASE_URL") ? BASE_URL : "/troyacrm") ?>/modules/agenda/events_api.php'
  });
  calendar.render();
});
</script>
<?php $extra_js = ob_get_clean();

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

// header + navbar padrão
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">

  <!-- Cabeçalho da página (mesmo padrão das outras telas) -->
  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-calendar2-week" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">Calendário</h1>
      </div>
      <div class="text-muted small mt-1">Visão mensal/semanal dos compromissos</div>
    </div>
    <div class="d-flex gap-2">
      <a href="<?php echo $BASE; ?>/modules/agenda/novo.php" class="btn btn-success">
        <i class="bi bi-plus-lg"></i> Novo compromisso
      </a>
      <a href="<?php echo $BASE; ?>/modules/agenda/index.php" class="btn btn-outline-secondary">
        <i class="bi bi-list-ul"></i> Lista
      </a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Agenda</div>
    <div class="card-body"><div id="calendar"></div></div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>