<?php
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../../app/db.php';
require_once __DIR__ . '/../../../app/rbac.php';

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

/* Permissões básicas */
if (!rbac_can('atendimentos','view')) { http_response_code(403); exit('Sem permissão.'); }
$canUpd = rbac_can('atendimentos','update');
$scUpd  = rbac_scope('atendimentos','update'); // own|all|none

/* CSRF */
if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }
$CSRF = $_SESSION['csrf'];

function back($ok=null,$err=null){
  global $BASE;
  $q = [];
  if ($ok)  $q['ok']  = $ok;
  if ($err) $q['err'] = $err;
  $qs = $q ? ('?'.http_build_query($q)) : '';
  header("Location: {$BASE}/admin/alertas{$qs}");
  exit;
}

try {
  if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    back(null, 'Método inválido.');
  }
  if (!hash_equals($CSRF, (string)($_POST['csrf'] ?? ''))) {
    back(null, 'CSRF inválido.');
  }

  $action = (string)($_POST['action'] ?? '');
  $id     = (int)($_POST['id'] ?? 0);

  if ($id <= 0 || $action === '') {
    back(null, 'Requisição incompleta.');
  }

  // Carrega o atendimento alvo
  $row = fetch_one("SELECT id, owner_user_id, created_by FROM interactions WHERE id = ?", [$id], true);
  if (!$row) {
    back(null, 'Atendimento não encontrado.');
  }

  // Helper de permissão por linha (para escopo own)
  $isOwn = in_array($me_id, [(int)($row['owner_user_id'] ?? 0), (int)($row['created_by'] ?? 0)], true);
  $mustOwn = ($scUpd === 'own');

  switch ($action) {
    case 'notificar':
      if (!$canUpd) back(null, 'Sem permissão para notificar.');
      if ($mustOwn && !$isOwn) back(null, 'Sem permissão neste registro.');

      $days = max(1, (int)($_POST['next_days'] ?? 2));
      execute(
        "UPDATE interactions SET next_followup_at = (NOW() + INTERVAL ? DAY), updated_at = NOW() WHERE id = ?",
        [$days, $id]
      );
      back('Corretor notificado (+'.$days.' dia(s)).');
      break;

    case 'assumir':
      if (!$canUpd) back(null, 'Sem permissão para assumir.');
      // aqui deixamos assumir mesmo fora do own (pedido de negócio)
      execute(
        "UPDATE interactions SET owner_user_id = ?, updated_at = NOW() WHERE id = ?",
        [$me_id, $id]
      );
      back('Atendimento assumido por você.');
      break;

    case 'reatribuir':
      // precisa ter update e ser admin ou update:all
      $isAdminOrAll = rbac_can('admin','access') || ($scUpd === 'all');
      if (!$canUpd || !$isAdminOrAll) back(null, 'Sem permissão para reatribuir.');

      $to_user_id = (int)($_POST['to_user_id'] ?? 0);
      if ($to_user_id <= 0) back(null, 'Selecione o novo responsável.');

      $dst = fetch_one("SELECT id FROM users WHERE id = ?", [$to_user_id], true);
      if (!$dst) back(null, 'Responsável inválido.');

      execute(
        "UPDATE interactions SET owner_user_id = ?, updated_at = NOW() WHERE id = ?",
        [$to_user_id, $id]
      );
      back('Responsável reatribuído.');
      break;

    case 'soneca':
      if (!$canUpd) back(null, 'Sem permissão para silenciar.');
      if ($mustOwn && !$isOwn) back(null, 'Sem permissão neste registro.');

      $snooze = max(1, (int)($_POST['snooze_days'] ?? 3));
      execute(
        "UPDATE interactions SET alerts_snooze_until = (NOW() + INTERVAL ? DAY), updated_at = NOW() WHERE id = ?",
        [$snooze, $id]
      );
      back('Alerta silenciado por '.$snooze.' dia(s).');
      break;

    default:
      back(null, 'Ação desconhecida.');
  }

} catch (Throwable $e) {
  back(null, $e->getMessage());
}