<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🔍 TESTE DE CONEXÃO - TROYA CRM</h2>";
echo "<hr>";

// Carregar configuração
$config = require 'config/config.php';

echo "<h3>📋 Configurações Carregadas:</h3>";
echo "<pre>";
echo "Host: " . $config['db']['host'] . "\n";
echo "Porta: " . ($config['db']['port'] ?? 'não definida') . "\n";
echo "Banco: " . $config['db']['name'] . "\n";
echo "Usuário: " . $config['db']['user'] . "\n";
echo "Senha: " . str_repeat('*', strlen($config['db']['pass'])) . " (" . strlen($config['db']['pass']) . " caracteres)\n";
echo "</pre>";

echo "<hr>";
echo "<h3>🔌 Testando Conexão...</h3>";

// Testar conexão SEM porta
try {
    $dsn1 = "mysql:host={$config['db']['host']};dbname={$config['db']['name']};charset=utf8mb4";
    echo "<p><strong>Tentativa 1:</strong> SEM porta<br>";
    echo "<code>$dsn1</code></p>";
    
    $pdo1 = new PDO($dsn1, $config['db']['user'], $config['db']['pass'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    
    echo "<p style='color: green;'>✅ <strong>SUCESSO!</strong> Conexão estabelecida SEM porta.</p>";
    $conexao_ok = 'sem_porta';
    $pdo = $pdo1;
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Falhou SEM porta: " . htmlspecialchars($e->getMessage()) . "</p>";
    
    // Testar conexão COM porta
    try {
        $dsn2 = "mysql:host={$config['db']['host']};port={$config['db']['port']};dbname={$config['db']['name']};charset=utf8mb4";
        echo "<p><strong>Tentativa 2:</strong> COM porta {$config['db']['port']}<br>";
        echo "<code>$dsn2</code></p>";
        
        $pdo2 = new PDO($dsn2, $config['db']['user'], $config['db']['pass'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);
        
        echo "<p style='color: green;'>✅ <strong>SUCESSO!</strong> Conexão estabelecida COM porta {$config['db']['port']}.</p>";
        $conexao_ok = 'com_porta';
        $pdo = $pdo2;
        
    } catch (PDOException $e2) {
        echo "<p style='color: red;'>❌ Falhou COM porta: " . htmlspecialchars($e2->getMessage()) . "</p>";
        $conexao_ok = false;
    }
}

// Se conectou, testar tabelas
if (isset($pdo)) {
    echo "<hr>";
    echo "<h3>📊 Testando Banco de Dados:</h3>";
    
    try {
        // Listar tabelas
        $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
        
        if (empty($tables)) {
            echo "<p style='color: orange;'>⚠️ <strong>Banco vazio!</strong> Nenhuma tabela encontrada.</p>";
            echo "<p>Você precisa importar o arquivo <code>database.sql</code> no phpMyAdmin.</p>";
        } else {
            echo "<p style='color: green;'>✅ Encontradas <strong>" . count($tables) . " tabelas</strong>:</p>";
            echo "<ul>";
            foreach ($tables as $table) {
                // Contar registros
                $count = $pdo->query("SELECT COUNT(*) FROM `$table`")->fetchColumn();
                echo "<li><strong>$table</strong>: $count registros</li>";
            }
            echo "</ul>";
        }
        
        // Testar consulta específica
        echo "<hr>";
        echo "<h3>🏠 Testando Consulta de Imóveis:</h3>";
        $imoveis = $pdo->query("SELECT COUNT(*) FROM properties WHERE status = 'publicado'")->fetchColumn();
        echo "<p>Imóveis publicados: <strong>$imoveis</strong></p>";
        
        echo "<h3>👥 Testando Consulta de Clientes:</h3>";
        $clientes = $pdo->query("SELECT COUNT(*) FROM clients")->fetchColumn();
        echo "<p>Total de clientes: <strong>$clientes</strong></p>";
        
    } catch (PDOException $e) {
        echo "<p style='color: red;'>❌ Erro ao consultar banco: " . htmlspecialchars($e->getMessage()) . "</p>";
    }
}

echo "<hr>";
echo "<h3>📝 Recomendação:</h3>";

if ($conexao_ok === 'sem_porta') {
    echo "<p style='color: green;'>✅ Use <strong>SEM porta</strong> no config.php:</p>";
    echo "<pre>\"host\" => \"localhost\",\n\"port\" => \"\",  // deixe vazio</pre>";
} elseif ($conexao_ok === 'com_porta') {
    echo "<p style='color: green;'>✅ Use <strong>COM porta</strong> no config.php:</p>";
    echo "<pre>\"host\" => \"localhost\",\n\"port\" => \"3306\",</pre>";
} else {
    echo "<p style='color: red;'>❌ <strong>Nenhuma conexão funcionou!</strong></p>";
    echo "<p>Verifique:</p>";
    echo "<ol>";
    echo "<li>Se o banco <code>{$config['db']['name']}</code> existe no cPanel</li>";
    echo "<li>Se o usuário <code>{$config['db']['user']}</code> tem permissões</li>";
    echo "<li>Se a senha está correta</li>";
    echo "<li>Se o usuário foi adicionado ao banco no cPanel</li>";
    echo "</ol>";
}

echo "<hr>";
echo "<p><a href='dashboard.php' style='padding: 10px 20px; background: #238636; color: white; text-decoration: none; border-radius: 4px;'>Voltar ao Dashboard</a></p>";
?>
