<?php
// TESTE ISOLADO DO db.php
echo "<h1>TESTE ISOLADO: app/db.php</h1>";
echo "<p>1. Iniciando teste...</p>";

// Tentar incluir o db.php
try {
    echo "<p>2. Tentando incluir app/db.php...</p>";
    require_once __DIR__ . '/app/db.php';
    echo "<p>3. app/db.php incluído com SUCESSO!</p>";
    
    // Testar uma função simples
    echo "<p>4. Testando função db()...</p>";
    $pdo = db();
    echo "<p>5. Função db() executada com SUCESSO!</p>";
    
    // Testar uma consulta simples
    echo "<p>6. Testando consulta simples...</p>";
    $result = fetch_one("SELECT COUNT(*) as total FROM users", [], true);
    echo "<p>7. Consulta executada! Usuários: " . ($result['total'] ?? 'ERRO') . "</p>";
    
    echo "<h2>✅ TODOS OS TESTES PASSARAM!</h2>";
    
} catch (Exception $e) {
    echo "<h2>❌ ERRO NO db.php:</h2>";
    echo "<p><strong>Mensagem:</strong> " . $e->getMessage() . "</p>";
    echo "<p><strong>Arquivo:</strong> " . $e->getFile() . "</p>";
    echo "<p><strong>Linha:</strong> " . $e->getLine() . "</p>";
    echo "<pre><strong>Trace:</strong>\n" . $e->getTraceAsString() . "</pre>";
} catch (Error $e) {
    echo "<h2>❌ ERRO FATAL NO db.php:</h2>";
    echo "<p><strong>Mensagem:</strong> " . $e->getMessage() . "</p>";
    echo "<p><strong>Arquivo:</strong> " . $e->getFile() . "</p>";
    echo "<p><strong>Linha:</strong> " . $e->getLine() . "</p>";
    echo "<pre><strong>Trace:</strong>\n" . $e->getTraceAsString() . "</pre>";
}
?>
