<?php
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

$page_title = 'Remover usuário';
$active     = 'usuarios';

// precisa ter permissão para excluir
rbac_require('usuarios','delete');

$pdo = function_exists('db') ? db() : (isset($pdo) ? $pdo : ($GLOBALS['pdo'] ?? null));
if (!($pdo instanceof PDO)) { throw new RuntimeException('Conexão PDO não encontrada.'); }

function q_one($s,$p=[]){ global $pdo;$st=$pdo->prepare($s);$st->execute($p);$r=$st->fetchAll(PDO::FETCH_ASSOC);return $r?$r[0]:null; }
function q_exec($s,$p=[]){ global $pdo;$st=$pdo->prepare($s);return $st->execute($p); }
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { http_response_code(400); exit('ID inválido'); }

$me_id = (int)($_SESSION['user']['id'] ?? 0);
$u = q_one("SELECT id, nome, email, role, ativo FROM users WHERE id = ?", [$id]);
if (!$u) { http_response_code(404); exit('Usuário não encontrado'); }

// Proteções: não remover o admin principal (#1) nem a si mesmo
if ($id === 1) {
  $msg = 'Não é permitido remover o usuário administrador principal (#1).';
} elseif ($id === $me_id) {
  $msg = 'Você não pode remover a si mesmo.';
}

if (!empty($msg)) {
  include __DIR__ . '/../../layout/header.php';
  include __DIR__ . '/../../layout/nav.php';
  ?>
  <div class="container my-4">
    <div class="card">
      <div class="card-header">Remoção bloqueada</div>
      <div class="card-body">
        <div class="alert alert-warning"><?= h($msg) ?></div>
        <a href="<?= $BASE ?>/usuarios" class="btn btn-outline-secondary">
          <i class="bi bi-arrow-left"></i> Voltar
        </a>
      </div>
    </div>
  </div>
  <?php include __DIR__ . '/../../layout/footer.php'; exit;
}

// Soft delete (mantém histórico): ativo = 0
q_exec("UPDATE users SET ativo = 0, updated_at = NOW() WHERE id = ?", [$id]);

// Se preferir excluir definitivamente, troque a linha acima por:
// q_exec("DELETE FROM users WHERE id = ?", [$id]);

header("Location: {$BASE}/usuarios");
exit;