<?php
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

$BASE       = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$page_title = 'Usuários';
$active     = 'usuarios';

// apenas quem pode ver este módulo
rbac_require('usuarios','view', ['message' => 'Somente administradores podem gerenciar usuários.']);

$pdo = function_exists('db') ? db() : (isset($pdo) ? $pdo : (isset($GLOBALS['pdo']) ? $GLOBALS['pdo'] : null));
function q_all($s,$p=[]){ global $pdo; $st=$pdo->prepare($s); $st->execute($p); return $st->fetchAll(PDO::FETCH_ASSOC); }
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

// gate para exibir botão "Permissões": apenas admin/gerente
$role = strtolower($_SESSION['user']['role'] ?? '');
$canGrantPerms = in_array($role, ['admin','manager','gerente'], true);

$err   = null;
$users = [];
try {
  $users = q_all("SELECT id, nome, email, role, ativo FROM users ORDER BY id DESC");
} catch (Throwable $e) {
  $err = $e->getMessage();
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-people" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">Usuários</h1>
      </div>
      <div class="text-muted small mt-1">Gerencie permissões por usuário</div>
    </div>

    <!-- Ações do topo -->
    <div class="d-flex gap-2">
      <?php if (rbac_can('usuarios','create')): ?>
        <a href="<?= $BASE ?>/modules/usuarios/novo.php" class="btn btn-success">
          <i class="bi bi-plus-lg"></i> Novo usuário
        </a>
      <?php endif; ?>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Lista de usuários</div>
    <div class="card-body">
      <?php if (!empty($err)): ?>
        <div class="alert alert-danger"><strong>Erro:</strong> <?= h($err) ?></div>
      <?php endif; ?>

      <?php if (!$users): ?>
        <div class="empty-state">
          <i class="bi bi-person-x"></i>
          <h5>Nenhum usuário encontrado</h5>
          <p>Crie usuários e depois defina permissões.</p>
          <?php if (rbac_can('usuarios','create')): ?>
            <a href="<?= $BASE ?>/modules/usuarios/novo.php" class="btn btn-success">
              <i class="bi bi-plus-lg"></i> Novo usuário
            </a>
          <?php endif; ?>
        </div>
      <?php else: ?>
        <div class="table-responsive">
          <table class="table table-dark table-hover align-middle mb-0">
            <thead>
              <tr>
                <th style="width:72px">ID</th>
                <th>Nome</th>
                <th>Email</th>
                <th class="d-none d-md-table-cell">Função</th>
                <th class="d-none d-md-table-cell">Ativo</th>
                <th class="text-end" style="width:300px">Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($users as $u): ?>
                <tr>
                  <td><?= (int)$u['id'] ?></td>
                  <td><?= h($u['nome']) ?></td>
                  <td><?= h($u['email']) ?></td>
                  <td class="d-none d-md-table-cell"><?= h($u['role'] ?? '-') ?></td>
                  <td class="d-none d-md-table-cell"><?= ($u['ativo'] ?? 1) ? 'Sim' : 'Não' ?></td>
                  <td class="text-end">
                    <div class="btn-group">
                      <?php if (rbac_can('usuarios','update')): ?>
                        <a class="btn btn-sm btn-outline-secondary"
                           href="<?= $BASE ?>/modules/usuarios/editar.php?id=<?= (int)$u['id'] ?>">
                          <i class="bi bi-pencil"></i> Editar
                        </a>
                      <?php endif; ?>

                      <?php if ($canGrantPerms): ?>
                        <a class="btn btn-sm btn-outline-warning"
                           href="<?= $BASE ?>/modules/usuarios/permissoes.php?user_id=<?= (int)$u['id'] ?>">
                          <i class="bi bi-shield-lock"></i> Permissões
                        </a>
                      <?php endif; ?>

                      <?php if (rbac_can('usuarios','delete')): ?>
                        <a class="btn btn-sm btn-outline-danger"
                           href="<?= $BASE ?>/modules/usuarios/remover.php?id=<?= (int)$u['id'] ?>"
                           onclick="return confirm('Remover este usuário?');">
                          <i class="bi bi-trash"></i> Excluir
                        </a>
                      <?php endif; ?>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>