<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

$page_title = 'Editar Negócio';
$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

rbac_require('negocios','update');

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { header("Location: {$BASE}/negocios"); exit; }

$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

/* Carregar negócio */
$deal = fetch_one("SELECT * FROM deals WHERE id = ?", [$id], true);
if (!$deal) { header("Location: {$BASE}/negocios"); exit; }

/* Escopo de edição */
$updScope = rbac_scope('negocios','update'); // 'own' | 'all'
if ($updScope === 'own' && (int)$deal['owner_user_id'] !== $me_id) {
    http_response_code(403); exit('Você não tem permissão para editar este negócio.');
}

$erros = [];
$ok = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $titulo = trim($_POST['titulo'] ?? '');
    $valor  = ($_POST['valor'] ?? '') === '' ? null : (float)$_POST['valor'];
    $etapa  = $_POST['etapa'] ?? 'novo';
    $prob   = ($_POST['prob']  ?? '') === '' ? null : (int)$_POST['prob'];
    $data_prevista = $_POST['data_prevista'] ?? null;

    if ($titulo === '') $erros[] = 'Título é obrigatório.';
    if (!in_array($etapa, ['novo','qualificando','proposta','negociando','ganho','perdido'], true)) {
        $erros[] = 'Etapa inválida.';
    }
    if ($prob !== null && ($prob < 0 || $prob > 100)) $erros[] = 'Probabilidade deve ser entre 0 e 100.';

    if (!$erros) {
        try {
            execute("
                UPDATE deals
                   SET titulo = ?, valor = ?, etapa = ?, prob = ?, data_prevista = ?, updated_at = NOW()
                 WHERE id = ?
            ", [$titulo, $valor, $etapa, $prob, $data_prevista ?: null, $id]);
            $ok = true;
            $deal = fetch_one("SELECT * FROM deals WHERE id = ?", [$id], true);
        } catch (Throwable $e) {
            $erros[] = 'Erro ao salvar: ' . $e->getMessage();
        }
    }
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0"><i class="bi bi-pencil"></i> Editar Negócio</h1>
    <a class="btn btn-outline-secondary" href="<?=$BASE?>/negocios"><i class="bi bi-arrow-left"></i> Voltar</a>
  </div>

  <?php if ($ok): ?>
    <div class="alert alert-success alert-dismissible fade show">
      <i class="bi bi-check-circle"></i> Alterações salvas com sucesso!
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <?php if ($erros): ?>
    <div class="alert alert-danger">
      <strong>Erros:</strong>
      <ul class="mb-0"><?php foreach ($erros as $e) echo '<li>'.htmlspecialchars($e).'</li>'; ?></ul>
    </div>
  <?php endif; ?>

  <form method="post" class="card card-body">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Título *</label>
        <input type="text" name="titulo" class="form-control" required value="<?=htmlspecialchars($deal['titulo'])?>">
      </div>
      <div class="col-md-3">
        <label class="form-label">Valor</label>
        <input type="number" step="0.01" name="valor" class="form-control" value="<?=htmlspecialchars($deal['valor'])?>">
      </div>
      <div class="col-md-3">
        <label class="form-label">Probabilidade (%)</label>
        <input type="number" name="prob" min="0" max="100" class="form-control" value="<?=htmlspecialchars($deal['prob'])?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Etapa</label>
        <select name="etapa" class="form-select">
          <?php
            $etapas = ['novo','qualificando','proposta','negociando','ganho','perdido'];
            foreach ($etapas as $e) {
              $sel = $deal['etapa'] === $e ? 'selected' : '';
              echo "<option value=\"$e\" $sel>".ucfirst($e)."</option>";
            }
          ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Data prevista</label>
        <input type="date" name="data_prevista" class="form-control" value="<?=htmlspecialchars($deal['data_prevista'])?>">
      </div>
    </div>

    <div class="mt-3 d-flex gap-2">
      <button class="btn btn-primary"><i class="bi bi-check2-circle"></i> Salvar</button>
      <a class="btn btn-outline-secondary" href="<?=$BASE?>/negocios"><i class="bi bi-x-circle"></i> Cancelar</a>
    </div>
  </form>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>