<?php
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

// PDO resiliente
$__pdo = null;
if (function_exists('db')) { $__pdo = db(); }
elseif (isset($pdo) && $pdo instanceof PDO) { $__pdo = $pdo; }
elseif (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) { $__pdo = $GLOBALS['pdo']; }
else { throw new RuntimeException('Conexão PDO não encontrada.'); }

function q_all($sql,$p=[]){ global $__pdo;$st=$__pdo->prepare($sql);$st->execute($p);return $st->fetchAll(PDO::FETCH_ASSOC);}
function q_exec($sql,$p=[]){ global $__pdo;$st=$__pdo->prepare($sql);return $st->execute($p);}
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

// ---------- PROCESSA POST ANTES DO HEADER (para permitir redirect) ----------
$errors = [];
$titulo = trim($_POST['titulo'] ?? '');
$inicio = trim($_POST['inicio'] ?? '');
$fim    = trim($_POST['fim'] ?? '');
$property_id = (isset($_POST['property_id']) && $_POST['property_id']!=='') ? (int)$_POST['property_id'] : null;
$client_id   = (isset($_POST['client_id'])   && $_POST['client_id']  !=='') ? (int)$_POST['client_id']   : null;
$obs    = trim($_POST['obs'] ?? '');

// ID do usuário logado
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if ($titulo === '') $errors[] = 'Informe o título';
  if ($inicio === '') $errors[] = 'Informe a data/hora inicial';
  if (!$errors) {
    q_exec("INSERT INTO agenda (titulo,inicio,fim,property_id,client_id,obs,owner_user_id,created_at) VALUES (?,?,?,?,?,?,?,NOW())",
      [$titulo,$inicio,($fim?:null),$property_id,$client_id,($obs?:null),$me_id]);
    header("Location: {$BASE}/modules/agenda/index.php");
    exit;
  }
}

/* ----------------- CARREGAR SELECTS ----------------- */

// Imóveis: todos podem visualizar (conforme combinado)
$imoveis  = q_all("SELECT id, titulo, cidade, uf FROM properties ORDER BY id DESC");

// Clientes: apenas do próprio usuário, a menos que tenha escopo 'all'
$clientes = [];
$scopeViewClientes = rbac_scope('clientes','view'); // 'none' | 'own' | 'all'

if ($scopeViewClientes === 'all') {
  // Admin/gerente: vê todos
  $clientes = q_all("SELECT id, nome_completo AS nome FROM clients ORDER BY nome_completo ASC");
} elseif ($scopeViewClientes === 'own') {
  // Corretor/usuário comum: apenas seus clientes
  // Considera bases antigas que usam created_by e a nova coluna owner_user_id
  $clientes = q_all(
    "SELECT id, nome_completo AS nome
       FROM clients
      WHERE (owner_user_id = ?)
         OR (owner_user_id IS NULL AND created_by = ?)
      ORDER BY nome_completo ASC",
    [$me_id, $me_id]
  );
} else {
  // 'none' -> sem permissão para ver clientes: não carrega opções
  $clientes = [];
}

$page_title = 'Novo compromisso';
include __DIR__ . '/../../layout/header.php';
?>
<div class="container my-4">
  <div class="card">
    <div class="card-header">Novo compromisso</div>
    <div class="card-body">
      <?php if ($errors): ?><div class="alert alert-danger"><?php foreach ($errors as $e) echo '<div>'.h($e).'</div>'; ?></div><?php endif; ?>
      <form method="post">
        <div class="row g-3">
          <div class="col-md-6"><label class="form-label">Título <span class="text-danger">*</span></label>
            <input type="text" name="titulo" class="form-control" value="<?= h($titulo) ?>" placeholder="Ex.: Visita ao imóvel"></div>
          <div class="col-md-3"><label class="form-label">Início <span class="text-danger">*</span></label>
            <input type="datetime-local" name="inicio" class="form-control" value="<?= h($inicio) ?>"></div>
          <div class="col-md-3"><label class="form-label">Fim</label>
            <input type="datetime-local" name="fim" class="form-control" value="<?= h($fim) ?>"></div>

          <div class="col-md-6"><label class="form-label">Imóvel (casa)</label>
            <select name="property_id" class="form-select">
              <option value="">— Selecionar (opcional) —</option>
              <?php foreach ($imoveis as $p):
                $rotulo = trim(($p['titulo'].' - '.trim(($p['cidade'].'/'.$p['uf']), '/'))); $rotulo = $rotulo ?: ('Imóvel #'.(int)$p['id']); ?>
                <option value="<?= (int)$p['id'] ?>" <?= ($property_id===(int)$p['id'])?'selected':'' ?>><?= h($rotulo) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-6"><label class="form-label">Cliente (opcional)</label>
            <?php if ($scopeViewClientes === 'none'): ?>
              <input type="text" class="form-control" value="Sem permissão para visualizar clientes" disabled>
            <?php else: ?>
              <select name="client_id" class="form-select">
                <option value="">— Selecionar (opcional) —</option>
                <?php foreach ($clientes as $c): ?>
                  <option value="<?= (int)$c['id'] ?>" <?= ($client_id===(int)$c['id'])?'selected':'' ?>><?= h($c['nome']) ?></option>
                <?php endforeach; ?>
              </select>
            <?php endif; ?>
          </div>

          <div class="col-12"><label class="form-label">Observações</label>
            <textarea name="obs" class="form-control" rows="4" placeholder="Anote qualquer detalhe importante"><?= h($obs) ?></textarea>
          </div>
        </div>

        <div class="mt-4 d-flex gap-2">
          <button class="btn btn-primary">Salvar</button>
          <a href="<?= $BASE ?>/modules/agenda/index.php" class="btn btn-outline-secondary">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>