<?php
require_once __DIR__ . '/../../app/db.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

require_once __DIR__ . '/../../app/rbac.php';
rbac_require('agenda','update');

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { header("Location: {$BASE}/agenda"); exit; }

$ag = fetch_one("SELECT * FROM agenda WHERE id = ?", [$id], true);
if (!$ag) { header("Location: {$BASE}/agenda"); exit; }

// bloqueio por escopo
$scopeUpd = rbac_scope('agenda','update'); // 'own' | 'all'
if ($scopeUpd === 'own' && isset($ag['owner_user_id']) && (int)$ag['owner_user_id'] !== $me_id) {
    http_response_code(403); exit('Você não tem permissão para editar este compromisso.');
}

// POST
$errors = [];
$titulo = trim($_POST['titulo'] ?? $ag['titulo']);
$inicio = trim($_POST['inicio'] ?? $ag['inicio']);
$fim    = trim($_POST['fim'] ?? $ag['fim']);
$property_id = isset($_POST['property_id']) ? (($_POST['property_id']!=='') ? (int)$_POST['property_id'] : null) : $ag['property_id'];
$client_id   = isset($_POST['client_id'])   ? (($_POST['client_id']  !=='') ? (int)$_POST['client_id']   : null) : $ag['client_id'];
$obs = trim($_POST['obs'] ?? ($ag['obs'] ?? ''));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if ($titulo === '') $errors[] = 'Informe o título';
  if ($inicio === '') $errors[] = 'Informe a data/hora inicial';
  if (!$errors) {
    execute("UPDATE agenda SET titulo=?, inicio=?, fim=?, property_id=?, client_id=?, obs=? WHERE id=?",
      [$titulo, $inicio, ($fim?:null), $property_id, $client_id, ($obs?:null), $id]);
    header("Location: {$BASE}/agenda");
    exit;
  }
}

// combos
$imoveis = fetch_all("SELECT id, titulo, cidade, uf FROM properties ORDER BY id DESC", [], true);

$clientes = [];
if (rbac_can('clientes','view')) {
  $scopeCli = rbac_scope('clientes','view');
  if ($scopeCli === 'own') {
    $clientes = fetch_all("SELECT id, nome_completo AS nome FROM clients WHERE owner_user_id=? ORDER BY nome_completo ASC", [$me_id], true);
  } else {
    $clientes = fetch_all("SELECT id, nome_completo AS nome FROM clients ORDER BY nome_completo ASC", [], true);
  }
}

$page_title = 'Editar compromisso';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';

$inicio_local = $inicio ? str_replace(' ','T',substr($inicio,0,16)) : '';
$fim_local    = $fim    ? str_replace(' ','T',substr($fim,0,16))    : '';
?>
<div class="container my-4">
  <div class="card">
    <div class="card-header">Editar compromisso</div>
    <div class="card-body">
      <?php if ($errors): ?><div class="alert alert-danger"><?php foreach ($errors as $e) echo '<div>'.h($e).'</div>'; ?></div><?php endif; ?>
      <form method="post">
        <div class="row g-3">
          <div class="col-md-6"><label class="form-label">Título <span class="text-danger">*</span></label>
            <input type="text" name="titulo" class="form-control" value="<?= h($titulo) ?>"></div>
          <div class="col-md-3"><label class="form-label">Início <span class="text-danger">*</span></label>
            <input type="datetime-local" name="inicio" class="form-control" value="<?= h($inicio_local) ?>"></div>
          <div class="col-md-3"><label class="form-label">Fim</label>
            <input type="datetime-local" name="fim" class="form-control" value="<?= h($fim_local) ?>"></div>

          <div class="col-md-6"><label class="form-label">Imóvel (opcional)</label>
            <select name="property_id" class="form-select">
              <option value="">— Selecionar —</option>
              <?php foreach ($imoveis as $p):
                $rotulo = trim(($p['titulo'].' - '.trim(($p['cidade'].'/'.$p['uf']), '/'))); $rotulo = $rotulo ?: ('Imóvel #'.(int)$p['id']); ?>
                <option value="<?= (int)$p['id'] ?>" <?= ((string)$property_id===(string)$p['id'])?'selected':'' ?>><?= h($rotulo) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-6"><label class="form-label">Cliente (opcional)</label>
            <select name="client_id" class="form-select" <?= empty($clientes)?'disabled':'' ?>>
              <option value=""><?= empty($clientes) ? '— sem permissão para listar clientes —' : '— Selecionar —' ?></option>
              <?php foreach ($clientes as $c): ?>
                <option value="<?= (int)$c['id'] ?>" <?= ((string)$client_id===(string)$c['id'])?'selected':'' ?>><?= h($c['nome']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-12"><label class="form-label">Observações</label>
            <textarea name="obs" class="form-control" rows="4"><?= h($obs) ?></textarea>
          </div>
        </div>

        <div class="mt-4 d-flex gap-2">
          <button class="btn btn-primary">Salvar</button>
          <a href="<?= $BASE ?>/agenda" class="btn btn-outline-secondary">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>