<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

/* Exige permissão de acesso ao Admin (mantido) */
rbac_require('admin','access');

$BASE       = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$page_title = 'Administração';
$active     = 'admin';

/* ===== Gates por funcionalidade =====
   Mantidos, com a correção do card Usuários para checar o módulo "usuarios" */
$canConfig    = rbac_can('admin','config_view') || rbac_can('admin','config_update');
$canUsers     = (
  rbac_can('usuarios','view')   ||
  rbac_can('usuarios','create') ||
  rbac_can('usuarios','update') ||
  rbac_can('usuarios','delete')
);
$canTransfer  = rbac_can('admin','transfer_owner');
$canCondos    = rbac_can('condominios','create') || rbac_can('condominios','update') || rbac_can('condominios','view');

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<style>
.admin-grid { display:grid; grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); gap:1rem; }
.admin-card { background: var(--bs-dark); border:1px solid rgba(255,255,255,.08); border-radius:.5rem; padding:1rem; }
.admin-card h5 { margin:0 0 .35rem; }
.admin-card p { margin:0 0 .75rem; color:#adb5bd; }
</style>

<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0"><i class="bi bi-gear me-2"></i>Administração</h1>
    <a class="btn btn-outline-secondary" href="<?= $BASE ?>/dashboard"><i class="bi bi-arrow-left"></i> Voltar</a>
  </div>

  <div class="admin-grid">
    <?php if ($canConfig): ?>
      <div class="admin-card">
        <h5><i class="bi bi-sliders me-1"></i>Configurações</h5>
        <p>Parâmetros do sistema (alertas de inatividade, etc.).</p>
        <a class="btn btn-primary" href="<?= $BASE ?>/admin/configuracoes">Abrir</a>
      </div>
    <?php endif; ?>

    <?php if ($canUsers): ?>
      <div class="admin-card">
        <h5><i class="bi bi-people me-1"></i>Usuários</h5>
        <p>Gerenciar usuários, permissões e acessos.</p>
        <!-- Link direto para o módulo de usuários (não /admin/usuarios) -->
        <a class="btn btn-primary" href="<?= $BASE ?>/usuarios">Abrir</a>
      </div>
    <?php endif; ?>

    <?php if ($canTransfer): ?>
      <div class="admin-card">
        <h5><i class="bi bi-arrow-left-right me-1"></i>Reatribuir Responsável</h5>
        <p>Transferir a posse (responsável) de clientes entre usuários.</p>
        <a class="btn btn-primary" href="<?= $BASE ?>/admin/reatribuir">Abrir</a>
      </div>
    <?php endif; ?>

    <?php if ($canCondos): ?>
      <div class="admin-card">
        <h5><i class="bi bi-buildings me-1"></i>Condomínios</h5>
        <p>Cadastro e gestão de condomínios para seleção nos imóveis.</p>
        <a class="btn btn-primary" href="<?= $BASE ?>/admin/condominios">Abrir</a>
      </div>
    <?php endif; ?>
  </div>

  <?php if (!$canConfig && !$canUsers && !$canTransfer && !$canCondos): ?>
    <div class="alert alert-warning mt-3 mb-0">
      Você tem acesso ao módulo de Administração, mas não possui permissões para visualizar itens internos.
      Solicite ao administrador ajustes nas permissões.
    </div>
  <?php endif; ?>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>