<?php
/* nav.php */
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

$canSeeAlerts = false;
$alert_count  = 0;
$me_id        = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

try {
  $hasViewAt = function_exists('rbac_can') ? rbac_can('atendimentos','view') : false;
  $scopeAt   = function_exists('rbac_scope') ? rbac_scope('atendimentos','view') : 'none'; // own|all|none

  // Lê configurações (settings primeiro; fallback para system_configs)
  $alertsEnabled = true; // fallback
  $days = 3;             // fallback

  if (function_exists('fetch_one')) {
    try {
      $rEnabled = fetch_one("SELECT value FROM settings WHERE `key`='alerts.enabled' LIMIT 1", [], true);
      if ($rEnabled !== null) { $alertsEnabled = ((string)$rEnabled['value'] === '1'); }
    } catch (Throwable $e) {}

    try {
      $rDays = fetch_one("SELECT value FROM settings WHERE `key`='alerts.days_without_update' LIMIT 1", [], true);
      if ($rDays && is_numeric($rDays['value'])) {
        $days = max(1, (int)$rDays['value']);
      } else {
        $cfg = fetch_one("SELECT `value` FROM system_configs WHERE `key`='alerts_inactivity_days' LIMIT 1", [], true);
        if ($cfg && is_numeric($cfg['value'])) { $days = max(1, (int)$cfg['value']); }
      }
    } catch (Throwable $e) {}
  }

  // Exibe sino se: tem permissão de ver atendimentos E alertas estão habilitados
  $canSeeAlerts = $hasViewAt && $alertsEnabled;

  if ($canSeeAlerts && function_exists('fetch_one')) {
    $ownerWhere = '';
    $params = [$days];

    if ($scopeAt === 'own') {
      $ownerWhere = " AND (i.owner_user_id = ? OR (i.owner_user_id IS NULL AND i.created_by = ?)) ";
      $params[] = $me_id;
      $params[] = $me_id;
    }

    // 1) Query principal: com last_activity_at E ignorando soneca
    $sql1 = "
      SELECT COUNT(*) AS c
        FROM interactions i
       WHERE i.status <> 'finalizado'
         AND (i.alerts_snooze_until IS NULL OR i.alerts_snooze_until < NOW())
         AND TIMESTAMPDIFF(
               DAY,
               COALESCE(
                 (SELECT MAX(l.created_at) FROM interaction_logs l WHERE l.interaction_id = i.id),
                 i.last_activity_at,
                 i.updated_at,
                 i.created_at
               ),
               NOW()
             ) >= ?
             {$ownerWhere}
    ";

    // 2) Fallback: sem last_activity_at, mas ainda ignorando soneca
    $sql2 = "
      SELECT COUNT(*) AS c
        FROM interactions i
       WHERE i.status <> 'finalizado'
         AND (i.alerts_snooze_until IS NULL OR i.alerts_snooze_until < NOW())
         AND TIMESTAMPDIFF(
               DAY,
               COALESCE(
                 (SELECT MAX(l.created_at) FROM interaction_logs l WHERE l.interaction_id = i.id),
                 i.updated_at,
                 i.created_at
               ),
               NOW()
             ) >= ?
             {$ownerWhere}
    ";

    // 3) Fallback final: sem last_activity_at e sem coluna de soneca (ambiente legado)
    $sql3 = "
      SELECT COUNT(*) AS c
        FROM interactions i
       WHERE i.status <> 'finalizado'
         AND TIMESTAMPDIFF(
               DAY,
               COALESCE(
                 (SELECT MAX(l.created_at) FROM interaction_logs l WHERE l.interaction_id = i.id),
                 i.updated_at,
                 i.created_at
               ),
               NOW()
             ) >= ?
             {$ownerWhere}
    ";

    try {
      $rowC = fetch_one($sql1, $params, true);
    } catch (Throwable $e1) {
      try {
        $rowC = fetch_one($sql2, $params, true);
      } catch (Throwable $e2) {
        $rowC = fetch_one($sql3, $params, true);
      }
    }

    $alert_count = (int)($rowC['c'] ?? 0);
  }
} catch (Throwable $e) {
  $canSeeAlerts = false; $alert_count = 0;
}
?>
<!-- NAVBAR -->
<nav class="navbar navbar-expand-lg navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= BASE_URL ?>/dashboard">
      <i class="bi bi-house-door-fill me-2"></i>Troya CRM
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        <li class="nav-item">
          <a class="nav-link" href="<?= BASE_URL ?>/dashboard">
            <i class="bi bi-speedometer2 me-1"></i>Dashboard
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?= BASE_URL ?>/imoveis">
            <i class="bi bi-house-door me-1"></i>Imóveis
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?= BASE_URL ?>/clientes">
            <i class="bi bi-people me-1"></i>Clientes
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?= BASE_URL ?>/agenda">
            <i class="bi bi-calendar3 me-1"></i>Agenda
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?= BASE_URL ?>/atendimentos">
            <i class="bi bi-headset me-1"></i>Atendimentos
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?= BASE_URL ?>/negocios">
            <i class="bi bi-kanban me-1"></i>Negócios
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?= BASE_URL ?>/admin">
            <i class="bi bi-gear"></i> Administração
          </a>
        </li>
      </ul>

      <div class="d-flex align-items-center gap-3">
        <?php if ($canSeeAlerts): ?>
          <!-- Sino aponta para /admin/alertas (index.php) -->
          <a class="nav-link position-relative" href="<?= BASE_URL ?>/admin/alertas" title="Alertas de inatividade">
            <i class="bi bi-bell"></i>
            <?php if ($alert_count > 0): ?>
              <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                <?= $alert_count ?>
              </span>
            <?php endif; ?>
          </a>
        <?php endif; ?>

        <span class="navbar-text">
          <i class="bi bi-person-circle me-1"></i>
          <?= htmlspecialchars($_SESSION["user_name"] ?? 'Usuário') ?>
        </span>
        <a href="<?= BASE_URL ?>/logout" class="btn btn-outline-light btn-sm">
          <i class="bi bi-box-arrow-right me-1"></i>Sair
        </a>
      </div>
    </div>
  </div>
</nav>