<?php
// app/ui.php - helper para renderizar botões visíveis porém desabilitados quando sem permissão
if (!function_exists('rbac_btn_link')) {
  function rbac_btn_link($module,$action,$href,$label,$classes='btn btn-primary',$iconHtml='') {
    if (function_exists('rbac_can') && rbac_can($module,$action)) {
      return '<a href="'.htmlspecialchars($href).'" class="'.htmlspecialchars($classes).'">'.$iconHtml.$label.'</a>';
    }
    // Sem permissão -> visível porém bloqueado
    return '<a href="#" class="'.htmlspecialchars($classes).' disabled" tabindex="-1" aria-disabled="true"
              onclick="return false;" title="Sem permissão">'.$iconHtml.$label.'</a>';
  }
}
