<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

rbac_require('negocios','view');

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { header('Location: '.$BASE.'/negocios'); exit; }

$row = fetch_one("SELECT d.*, c.nome_completo cliente_nome, p.titulo imovel_titulo
                  FROM deals d
                  LEFT JOIN clients c ON c.id = d.client_id
                  LEFT JOIN properties p ON p.id = d.property_id
                  WHERE d.id = ?", [$id], true);
if (!$row) { header('Location: '.$BASE.'/negocios'); exit; }

$sv = rbac_scope('negocios','view');
if ($sv === 'own' && (int)$row['owner_user_id'] !== $me_id) {
    http_response_code(403); exit('Sem permissão para visualizar este negócio.');
}

/* pode editar/excluir? */
$canUpd = $canDel = false;
if (rbac_can('negocios','update')) {
    $su = rbac_scope('negocios','update');
    $canUpd = ($su === 'all') || ($su === 'own' && (int)$row['owner_user_id'] === $me_id);
}
if (rbac_can('negocios','delete')) {
    $sd = rbac_scope('negocios','delete');
    $canDel = ($sd === 'all') || ($sd === 'own' && (int)$row['owner_user_id'] === $me_id);
}

$page_title = 'Negócio: '.$row['titulo'];
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container mt-4 mb-5">
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <div><i class="bi bi-briefcase me-2"></i><strong><?=htmlspecialchars($row['titulo'])?></strong></div>
      <div class="d-flex gap-2">
        <span class="badge bg-secondary"><?=htmlspecialchars($row['etapa'])?></span>
        <?php if ($row['prob']!==null): ?><span class="badge bg-info"><?= (int)$row['prob'] ?>%</span><?php endif; ?>
      </div>
    </div>
    <div class="card-body">
      <div class="row g-3">
        <div class="col-md-6">
          <div class="text-muted small">Cliente</div>
          <div class="fw-semibold"><?=htmlspecialchars($row['cliente_nome'] ?? '-')?></div>
        </div>
        <div class="col-md-6">
          <div class="text-muted small">Imóvel</div>
          <div class="fw-semibold"><?=htmlspecialchars($row['imovel_titulo'] ?? '-')?></div>
        </div>

        <div class="col-md-4">
          <div class="text-muted small">Valor</div>
          <div class="fw-semibold"><?= $row['valor']!==null ? 'R$ '.number_format($row['valor'],2,',','.') : '-' ?></div>
        </div>
        <div class="col-md-4">
          <div class="text-muted small">Data prevista</div>
          <div class="fw-semibold"><?= $row['data_prevista'] ? date('d/m/Y', strtotime($row['data_prevista'])) : '-' ?></div>
        </div>
        <div class="col-md-4">
          <div class="text-muted small">Criado em</div>
          <div class="fw-semibold"><?= $row['created_at'] ? date('d/m/Y H:i', strtotime($row['created_at'])) : '-' ?></div>
        </div>
      </div>
    </div>
    <div class="card-footer d-flex justify-content-between">
      <a class="btn btn-outline-secondary" href="<?=$BASE?>/negocios"><i class="bi bi-arrow-left me-2"></i>Voltar</a>
      <div class="d-flex gap-2">
        <?php if ($canUpd): ?>
          <a class="btn btn-primary" href="<?=$BASE?>/negocios/<?=$row['id']?>/editar"><i class="bi bi-pencil me-2"></i>Editar</a>
        <?php endif; ?>
        <?php if ($canDel): ?>
          <a class="btn btn-danger" href="<?=$BASE?>/negocios/<?=$row['id']?>/remover" onclick="return confirm('Excluir este negócio?');">
            <i class="bi bi-trash me-2"></i>Excluir
          </a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>