<?php
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

rbac_require('atendimentos','view');

$BASE   = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id  = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);
$scopeV = rbac_scope('atendimentos','view'); // own|all

// Lê dias da config
$days = 3;
try {
  $cfg = fetch_one("SELECT `value` FROM system_configs WHERE `key`='alerts_inactivity_days' LIMIT 1", [], true);
  if ($cfg && is_numeric($cfg['value'])) { $days = max(1, (int)$cfg['value']); }
} catch (Throwable $e) {}

$whereScope = '';
$params = [$days];

if ($scopeV === 'own') {
  $whereScope = " AND i.owner_user_id = ? ";
  $params[] = $me_id;
}

// Lista com cálculo por atendimento
$rows = fetch_all("
  SELECT
    i.id,
    i.client_id,
    i.owner_user_id,
    i.status,
    i.created_at,
    i.next_followup_at,
    c.nome_completo AS cliente_nome,
    u.nome          AS owner_nome,
    (SELECT MAX(l.created_at)
       FROM interaction_logs l
      WHERE l.interaction_id = i.id
        AND l.created_by     = i.owner_user_id
    ) AS last_owner_activity,
    TIMESTAMPDIFF(
      DAY,
      COALESCE(
        (SELECT MAX(l.created_at)
           FROM interaction_logs l
          WHERE l.interaction_id = i.id
            AND l.created_by     = i.owner_user_id),
        i.created_at
      ),
      NOW()
    ) AS dias_parado
  FROM interactions i
  LEFT JOIN clients c ON c.id = i.client_id
  LEFT JOIN users   u ON u.id = i.owner_user_id
  WHERE i.status <> 'finalizado'
    AND TIMESTAMPDIFF(
          DAY,
          COALESCE(
            (SELECT MAX(l.created_at)
               FROM interaction_logs l
              WHERE l.interaction_id = i.id
                AND l.created_by     = i.owner_user_id),
            i.created_at
          ),
          NOW()
        ) >= ?
        {$whereScope}
  ORDER BY dias_parado DESC, i.id DESC
  LIMIT 500
", $params, true) ?: [];

$page_title = 'Alertas de Inatividade';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0"><i class="bi bi-bell text-warning"></i> Alertas de Inatividade</h1>
    <a href="<?=$BASE?>/dashboard" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Voltar</a>
  </div>

  <div class="alert alert-warning">
    <i class="bi bi-info-circle me-2"></i>
    Exibindo atendimentos com <strong>inatividade do corretor</strong> maior ou igual a
    <strong><?= (int)$days ?></strong> dia(s).
  </div>

  <div class="card">
    <div class="table-responsive">
      <table class="table table-dark table-hover align-middle mb-0">
        <thead>
          <tr>
            <th style="width:80px">ID</th>
            <th>Cliente</th>
            <th style="width:220px">Responsável</th>
            <th style="width:160px">Status</th>
            <th style="width:180px">Últ. ação do corretor</th>
            <th style="width:140px">Dias parado</th>
            <th style="width:200px" class="text-end">Ações</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td>
              <strong><?= htmlspecialchars($r['cliente_nome'] ?? '—') ?></strong>
            </td>
            <td><?= htmlspecialchars($r['owner_nome'] ?? '—') ?></td>
            <td><span class="badge bg-secondary"><?= htmlspecialchars($r['status']) ?></span></td>
            <td><?= $r['last_owner_activity'] ? date('d/m/Y H:i', strtotime($r['last_owner_activity'])) : '— nunca' ?></td>
            <td><strong><?= (int)$r['dias_parado'] ?></strong></td>
            <td class="text-end">
              <div class="btn-group">
                <a class="btn btn-sm btn-outline-light" href="<?=$BASE?>/atendimentos/visualizar?id=<?= (int)$r['id'] ?>">
                  <i class="bi bi-eye"></i>
                </a>
                <?php if (rbac_can('atendimentos','update')): ?>
                  <a class="btn btn-sm btn-outline-success" href="<?=$BASE?>/atendimentos/editar?id=<?= (int)$r['id'] ?>">
                    <i class="bi bi-pencil"></i>
                  </a>
                <?php endif; ?>
                <?php if (rbac_can('admin','transfer_owner')): ?>
                  <a class="btn btn-sm btn-outline-warning" href="<?=$BASE?>/admin/reatribuir?q=<?= urlencode($r['cliente_nome'] ?? '') ?>">
                    <i class="bi bi-arrow-left-right"></i>
                  </a>
                <?php endif; ?>
              </div>
            </td>
          </tr>
          <?php endforeach; if (!$rows): ?>
          <tr><td colspan="7" class="text-center text-muted py-4">Nenhum alerta no momento.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>