<?php
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
require_once __DIR__ . '/app/db.php';

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$erro = null;

/* preserva o "next" vindo da URL ou do POST */
$next = (string)($_GET['next'] ?? $_POST['next'] ?? '');
/* valida next: só permite caminhos internos, começando por "/" e sem "://" */
$next_valid = ($next !== '' && substr($next,0,1)==='/' && strpos($next, '://') === false);

function pick_field(array $row, array $candidates, $default = null) {
    foreach ($candidates as $c) {
        if (array_key_exists($c, $row)) return $c;
    }
    return $default;
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST["email"] ?? "");
    $senha = (string)($_POST["senha"] ?? "");

    try {
        $cn = db();

        // Busca o usuário com SELECT * para tolerar nomes de colunas diferentes
        $st = $cn->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
        $st->execute([$email]);
        $u = $st->fetch(PDO::FETCH_ASSOC);

        $autenticado = false;

        if ($u) {
            // Descobre nomes das colunas
            $colId    = pick_field($u, ['id','user_id','uid','codigo']);
            $colNome  = pick_field($u, ['nome','name','full_name','usuario','username']);
            $colRole  = pick_field($u, ['role','perfil','cargo']);
            $colAtivo = pick_field($u, ['ativo','status','enabled','is_active']);

            $colHash  = pick_field($u, ['senha_hash','password_hash','pass_hash']);
            $colPlain = pick_field($u, ['senha','password','pass']);
            $colMd5   = pick_field($u, ['senha_md5','password_md5','pass_md5','md5']);

            // Verifica ativo (se não existir coluna, assume ativo)
            $ativoOk = true;
            if ($colAtivo !== null) {
                $v = strtolower((string)$u[$colAtivo]);
                $ativoOk = in_array($v, ['1','true','t','y','yes','ativo','active','enabled','on','sim'], true);
            }

            if ($ativoOk) {
                // 1) senha_hash (password_verify)
                if (!$autenticado && $colHash !== null && !empty($u[$colHash])) {
                    $autenticado = password_verify($senha, $u[$colHash]);
                }
                // 2) senha em texto puro (legado)
                if (!$autenticado && $colPlain !== null && $u[$colPlain] !== null) {
                    $autenticado = hash_equals((string)$u[$colPlain], $senha);
                    // migra para hash se existir coluna hash
                    if ($autenticado && $colHash !== null) {
                        try {
                            $hash = password_hash($senha, PASSWORD_DEFAULT);
                            $cn->prepare("UPDATE users SET `{$colHash}` = ? WHERE `{$colId}` = ?")
                               ->execute([$hash, (int)$u[$colId]]);
                        } catch (Throwable $e) { /* ignora */ }
                    }
                }
                // 3) senha md5 (legado)
                if (!$autenticado && $colMd5 !== null && !empty($u[$colMd5])) {
                    $autenticado = (md5($senha) === strtolower($u[$colMd5]));
                    if ($autenticado && $colHash !== null) {
                        try {
                            $hash = password_hash($senha, PASSWORD_DEFAULT);
                            $cn->prepare("UPDATE users SET `{$colHash}` = ?, `{$colMd5}` = NULL WHERE `{$colId}` = ?")
                               ->execute([$hash, (int)$u[$colId]]);
                        } catch (Throwable $e) { /* ignora */ }
                    }
                }

                if ($autenticado) {
                    session_regenerate_id(true);
                    $_SESSION["user_id"]   = (int)($u[$colId] ?? 0);
                    $_SESSION["user_name"] = (string)($colNome ? $u[$colNome] : '');
                    $_SESSION["logged_in"] = true;
                    $_SESSION["user"] = [
                        'id'    => (int)($u[$colId] ?? 0),
                        'nome'  => (string)($colNome ? $u[$colNome] : ''),
                        'email' => (string)$email,
                        'role'  => (string)($colRole ? ($u[$colRole] ?? '') : '')
                    ];

                    $dest = $next_valid ? $next : ($BASE . '/dashboard');
                    header("Location: {$dest}");
                    exit;
                }
            }
        }

        // Fallback de desenvolvimento (opcional)
        if (!$autenticado && $email === "admin@exemplo.com" && $senha === "123456") {
            $_SESSION["user_id"]   = 1;
            $_SESSION["user_name"] = "Administrador";
            $_SESSION["logged_in"] = true;
            $_SESSION["user"] = ['id'=>1,'nome'=>'Administrador','email'=>$email,'role'=>'admin'];
            $dest = $next_valid ? $next : ($BASE . '/dashboard');
            header("Location: {$dest}");
            exit;
        }

        $erro = "Email, senha inválidos ou usuário inativo.";
    } catch (Throwable $e) {
        $erro = "Falha ao autenticar. " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Troya CRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #0d1117 0%, #21262d 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; }
        .login-card { background: #161b22; border: 1px solid #30363d; border-radius: 8px; padding: 2rem; max-width: 400px; width: 100%; }
        .form-control { background: #0d1117; border: 1px solid #30363d; color: #e6edf3; }
        .form-control:focus { background: #0d1117; border-color: #238636; color: #e6edf3; }
        .btn-login { background: #238636; border-color: #238636; color: white; }
        .text-muted { color: #8b949e !important; }
    </style>
</head>
<body>
    <div class="login-card">
        <h3 class="text-center text-white mb-4">🏠 Troya CRM</h3>
        <?php if (!empty($erro)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>
        <form method="POST" autocomplete="off">
            <input type="hidden" name="next" value="<?= htmlspecialchars($next_valid ? $next : '') ?>">
            <div class="mb-3">
                <input type="email" name="email" class="form-control" placeholder="Email" required value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
            </div>
            <div class="mb-3">
                <input type="password" name="senha" class="form-control" placeholder="Senha" required>
            </div>
            <button type="submit" class="btn btn-login w-100">Entrar</button>
        </form>
        <div class="text-center mt-3">
            <small class="text-muted">Acesso restrito</small>
        </div>
    </div>
</body>
</html>