<?php
// app/mailer.php
if (!function_exists('db')) { require_once __DIR__ . '/db.php'; }

/* Ler settings da tabela settings */
function settings_get($key, $default=null){
  try {
    $r = fetch_one("SELECT value FROM settings WHERE `key` = ? LIMIT 1", [$key], true);
    return $r ? (string)$r['value'] : $default;
  } catch (Throwable $e) { return $default; }
}

/* Envia 1 email HTML (fallback no mail()) */
function mailer_send($toEmail, $toName, $subject, $htmlBody, $textAlt=''){
  $fromEmail = settings_get('smtp.from_email', 'nao-responda@seu-dominio.com.br');
  $fromName  = settings_get('smtp.from_name',  'Troya CRM');

  $boundary = md5(uniqid(time(), true));
  $headers  = [];
  $headers[] = 'MIME-Version: 1.0';
  $headers[] = 'From: ' . mb_encode_mimeheader($fromName, 'UTF-8') . " <{$fromEmail}>";
  $headers[] = 'Reply-To: ' . $fromEmail;
  $headers[] = 'Content-Type: multipart/alternative; boundary="'.$boundary.'"';
  $headers   = implode("\r\n", $headers);

  if ($textAlt === '') {
    $textAlt = strip_tags(preg_replace('~<br\s*/?>~i', "\n", $htmlBody));
  }
  $body  = "--{$boundary}\r\n";
  $body .= "Content-Type: text/plain; charset=UTF-8\r\n\r\n";
  $body .= "{$textAlt}\r\n";
  $body .= "--{$boundary}\r\n";
  $body .= "Content-Type: text/html; charset=UTF-8\r\n\r\n";
  $body .= "{$htmlBody}\r\n";
  $body .= "--{$boundary}--";

  $ok = @mail($toEmail, '=?UTF-8?B?'.base64_encode($subject).'?=', $body, $headers);
  return (bool)$ok;
}

/* Envia para vários, 1 a 1 (evita BCC expor lista) */
function mailer_send_many(array $recipients, $subject, $htmlBody, $textAlt=''){
  $sent = 0;
  foreach ($recipients as $r) {
    $email = trim($r['email'] ?? '');
    $name  = (string)($r['nome'] ?? '');
    if ($email !== '' && filter_var($email, FILTER_VALIDATE_EMAIL)) {
      if (mailer_send($email, $name, $subject, $htmlBody, $textAlt)) { $sent++; }
    }
  }
  return $sent;
}