<?php
// app/auth.php
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

/**
 * Redireciona para o login com ?next=<REQUEST_URI>, caso não esteja logado.
 * Em CLI não faz nada.
 */
function require_login(): void {
    if (php_sapi_name() === 'cli') return;

    if (empty($_SESSION['logged_in'])) {
        $base = defined('BASE_URL') ? rtrim(BASE_URL, '/') : '/troyacrm';
        // REQUEST_URI preserva caminho + query string
        $next = $_SERVER['REQUEST_URI'] ?? ($base . '/dashboard');
        header('Location: ' . $base . '/login?next=' . urlencode($next));
        exit;
    }
}

/** Retorna true se está logado (útil em cabeçalhos/menus) */
function is_logged_in(): bool {
    return !empty($_SESSION['logged_in']);
}