<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: /troyacrm/login");
    exit;
}

require_once __DIR__ . '/../../app/db.php';
$page_title = 'Imóveis';

// Exclusão com log
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    try {
        $id = intval($_GET['delete']);
        
        // Buscar título do imóvel antes de excluir
        $imovel_deletado = fetch_one("SELECT titulo FROM properties WHERE id = ?", [$id], true);
        
        if ($imovel_deletado) {
            $titulo_deletado = $imovel_deletado['titulo'];
            
            // Registrar log de exclusão ANTES de deletar
            try {
                $log_gravado = execute(
                    "INSERT INTO property_logs (property_id, user_id, acao, detalhes) VALUES (?, ?, 'excluido', ?)",
                    [$id, $_SESSION['user_id'], 'Exclusão do imóvel "' . $titulo_deletado . '"']
                );
                
                // Se log foi gravado com sucesso, excluir o imóvel
                if ($log_gravado === true) {
                    execute("DELETE FROM properties WHERE id = ?", [$id]);
                    $mensagem_sucesso = "Imóvel excluído com sucesso!";
                } else {
                    $mensagem_erro = "Erro ao registrar log de exclusão.";
                }
                
            } catch (Exception $log_error) {
                // Se falhar ao gravar log, registra erro mas não impede exclusão
                error_log("Erro ao gravar log de exclusão: " . $log_error->getMessage());
                
                // Excluir mesmo sem log (decisão de negócio - você pode mudar isso)
                execute("DELETE FROM properties WHERE id = ?", [$id]);
                $mensagem_sucesso = "Imóvel excluído (log não registrado).";
            }
            
        } else {
            $mensagem_erro = "Imóvel não encontrado.";
        }
        
    } catch (Exception $e) {
        $mensagem_erro = "Erro ao excluir imóvel: " . $e->getMessage();
    }
}

// Buscar imóveis
$imoveis = [];
$total_imoveis = 0;
$erro = null;

try {
    $sql = "SELECT * FROM properties ORDER BY created_at DESC LIMIT 50";
    $imoveis = fetch_all($sql, [], true);
    $total_imoveis = count($imoveis);
} catch (Exception $e) {
    $erro = $e->getMessage();
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>

<div class="container mt-4 mb-5">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <div>
      <h1 class="mb-1 fw-bold">
        <i class="bi bi-house-door me-2 text-success"></i>
        Imóveis
        <?php if ($total_imoveis > 0): ?>
          <span class="badge bg-secondary"><?php echo $total_imoveis; ?></span>
        <?php endif; ?>
      </h1>
      <p class="text-muted mb-0">Gerencie todos os seus imóveis</p>
    </div>
    <a href="<?=BASE_URL?>/imoveis/novo" class="btn btn-success">
      <i class="bi bi-plus me-2"></i>Novo Imóvel
    </a>
  </div>

  <?php if (isset($mensagem_sucesso)): ?>
    <div class="alert alert-success alert-dismissible fade show">
      <i class="bi bi-check-circle me-2"></i><?=$mensagem_sucesso?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <?php if (isset($mensagem_erro)): ?>
    <div class="alert alert-danger alert-dismissible fade show">
      <i class="bi bi-exclamation-triangle me-2"></i><?=$mensagem_erro?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <?php if ($erro): ?>
    <div class="alert alert-danger">
      <h5><i class="bi bi-exclamation-triangle me-2"></i>Erro ao carregar imóveis</h5>
      <p class="mb-0"><?=htmlspecialchars($erro)?></p>
    </div>
  <?php endif; ?>

  <?php if (empty($imoveis) && !$erro): ?>
    <div class="card">
      <div class="card-body text-center py-5">
        <i class="bi bi-house-door display-1 text-muted mb-3"></i>
        <h3 class="mb-3">Nenhum imóvel cadastrado</h3>
        <p class="text-muted mb-4">Você ainda não cadastrou nenhum imóvel. Comece agora!</p>
        <a href="<?=BASE_URL?>/imoveis/novo" class="btn btn-success btn-lg">
          <i class="bi bi-plus-circle me-2"></i>Cadastrar Primeiro Imóvel
        </a>
      </div>
    </div>
  <?php else: ?>
    <div class="card">
      <div class="table-responsive">
        <table class="table table-dark table-hover mb-0 align-middle">
          <thead>
            <tr>
              <th width="60">ID</th>
              <th>Título</th>
              <th width="180">Preço</th>
              <th width="180">Cidade</th>
              <th width="120">Status</th>
              <th width="150" class="text-center">Ações</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($imoveis as $imovel): ?>
              <tr>
                <td class="text-center"><?=$imovel['id']?></td>
                <td>
                  <strong><?=htmlspecialchars($imovel['titulo'])?></strong>
                </td>
                <td>
                  <span class="text-success fw-bold"><?=format_money($imovel['preco'])?></span>
                </td>
                <td><?=htmlspecialchars($imovel['cidade'])?></td>
                <td>
                  <?php
                    $status_classes = [
                      'publicado' => 'success',
                      'rascunho' => 'secondary',
                      'vendido' => 'danger',
                      'alugado' => 'info'
                    ];
                    $st = $status_classes[$imovel['status']] ?? 'secondary';
                  ?>
                  <span class="badge bg-<?=$st?>">
                    <?=ucfirst($imovel['status'])?>
                  </span>
                </td>
                <td class="text-center">
                  <div class="btn-group btn-group-sm">
                    <a href="<?=BASE_URL?>/imoveis/<?=$imovel['id']?>/visualizar" 
                       class="btn btn-outline-success" 
                       title="Visualizar imóvel"
                       target="_blank">
                      <i class="bi bi-eye"></i>
                    </a>
                    <a href="<?=BASE_URL?>/imoveis/<?=$imovel['id']?>/editar" 
                       class="btn btn-outline-primary" 
                       title="Editar imóvel">
                      <i class="bi bi-pencil"></i>
                    </a>
                    <a href="<?=BASE_URL?>/imoveis/<?=$imovel['id']?>/fotos" 
                       class="btn btn-outline-info" 
                       title="Gerenciar fotos">
                      <i class="bi bi-images"></i>
                    </a>
                    <a href="<?=BASE_URL?>/imoveis?delete=<?=$imovel['id']?>" 
                       class="btn btn-outline-danger" 
                       title="Excluir imóvel"
                       onclick="return confirm('Tem certeza que deseja excluir este imóvel?\n\nEsta ação não pode ser desfeita!')">
                      <i class="bi bi-trash"></i>
                    </a>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="card-footer text-muted d-flex justify-content-between align-items-center">
        <span><i class="bi bi-info-circle me-2"></i>Total: <strong><?=$total_imoveis?></strong> imóve<?=($total_imoveis!=1?'is':'l')?></span>
        <?php
          $publicados = count(array_filter($imoveis, fn($i) => $i['status'] == 'publicado'));
          $rascunhos  = count(array_filter($imoveis, fn($i) => $i['status'] == 'rascunho'));
        ?>
        <div>
          <span class="badge bg-success me-1"><?=$publicados?> publicado<?=$publicados!=1?'s':''?></span>
          <span class="badge bg-secondary"><?=$rascunhos?> rascunho<?=$rascunhos!=1?'s':''?></span>
        </div>
      </div>
    </div>
  <?php endif; ?>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
