<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION["logged_in"]) || !$_SESSION["logged_in"]) {
    header("Location: /troyacrm/login");
    exit;
}

require_once __DIR__ . '/../../app/db.php';
$page_title = 'Clientes';

// Exclusão com confirmação
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    try {
        $id = intval($_GET['delete']);
        
        // Buscar nome do cliente antes de excluir
        $cliente_deletado = fetch_one("SELECT nome_completo FROM clients WHERE id = ?", [$id], true);
        
        if ($cliente_deletado) {
            $nome_deletado = $cliente_deletado['nome_completo'];
            
            // Excluir cliente
            execute("DELETE FROM clients WHERE id = ?", [$id]);
            $mensagem_sucesso = "Cliente '$nome_deletado' excluído com sucesso!";
        } else {
            $mensagem_erro = "Cliente não encontrado.";
        }
        
    } catch (Exception $e) {
        $mensagem_erro = "Erro ao excluir cliente: " . $e->getMessage();
    }
}

// Buscar clientes
$clientes = [];
$total_clientes = 0;
$erro = null;

try {
    $sql = "SELECT * FROM clients ORDER BY created_at DESC LIMIT 50";
    $clientes = fetch_all($sql, [], true);
    $total_clientes = count($clientes);
} catch (Exception $e) {
    $erro = $e->getMessage();
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>

<div class="container mt-4 mb-5">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <div>
      <h1 class="mb-1 fw-bold">
        <i class="bi bi-people me-2 text-primary"></i>
        Clientes
        <?php if ($total_clientes > 0): ?>
          <span class="badge bg-secondary"><?php echo $total_clientes; ?></span>
        <?php endif; ?>
      </h1>
      <p class="text-muted mb-0">Gerencie todos os seus clientes</p>
    </div>
    <a href="<?=BASE_URL?>/clientes/criar" class="btn btn-primary">
      <i class="bi bi-plus me-2"></i>Novo Cliente
    </a>
  </div>

  <?php if (isset($mensagem_sucesso)): ?>
    <div class="alert alert-success alert-dismissible fade show">
      <i class="bi bi-check-circle me-2"></i><?=$mensagem_sucesso?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <?php if (isset($mensagem_erro)): ?>
    <div class="alert alert-danger alert-dismissible fade show">
      <i class="bi bi-exclamation-triangle me-2"></i><?=$mensagem_erro?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <?php if ($erro): ?>
    <div class="alert alert-danger">
      <h5><i class="bi bi-exclamation-triangle me-2"></i>Erro ao carregar clientes</h5>
      <p class="mb-0"><?=htmlspecialchars($erro)?></p>
    </div>
  <?php endif; ?>

  <?php if (empty($clientes) && !$erro): ?>
    <div class="card">
      <div class="card-body text-center py-5">
        <i class="bi bi-people display-1 text-muted mb-3"></i>
        <h3 class="mb-3">Nenhum cliente cadastrado</h3>
        <p class="text-muted mb-4">Você ainda não cadastrou nenhum cliente. Comece agora!</p>
        <a href="<?=BASE_URL?>/clientes/criar" class="btn btn-primary btn-lg">
          <i class="bi bi-plus-circle me-2"></i>Cadastrar Primeiro Cliente
        </a>
      </div>
    </div>
  <?php else: ?>
    <div class="card">
      <div class="table-responsive">
        <table class="table table-dark table-hover mb-0 align-middle">
          <thead>
            <tr>
              <th width="60">ID</th>
              <th>Nome</th>
              <th width="180">CPF/CNPJ</th>
              <th width="180">Telefone</th>
              <th width="120">Tipo</th>
              <th width="150" class="text-center">Ações</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($clientes as $cliente): ?>
              <tr>
                <td class="text-center"><?=$cliente['id']?></td>
                <td>
                  <strong><?=htmlspecialchars($cliente['nome_completo'])?></strong>
                  <?php if ($cliente['email']): ?>
                    <br><small class="text-muted"><?=htmlspecialchars($cliente['email'])?></small>
                  <?php endif; ?>
                </td>
                <td>
                  <span class="text-info fw-bold"><?=htmlspecialchars($cliente['cpf_cnpj'])?></span>
                </td>
                <td>
                  <span class="text-success fw-bold"><?=htmlspecialchars($cliente['telefone_principal'])?></span>
                  <?php if ($cliente['telefone_secundario']): ?>
                    <br><small class="text-muted"><?=htmlspecialchars($cliente['telefone_secundario'])?></small>
                  <?php endif; ?>
                </td>
                <td>
                  <?php
                    $tipos_classes = [
                      'comprador' => 'primary',
                      'vendedor' => 'success',
                      'locatario' => 'info',
                      'proprietario' => 'warning'
                    ];
                    $tipo = $tipos_classes[$cliente['tipo_cliente']] ?? 'secondary';
                  ?>
                  <span class="badge bg-<?=$tipo?>">
                    <?=ucfirst($cliente['tipo_cliente'])?>
                  </span>
                </td>
                <td class="text-center">
                  <div class="btn-group btn-group-sm">
                    <a href="<?=BASE_URL?>/clientes/<?=$cliente['id']?>/editar" 
                       class="btn btn-outline-primary" 
                       title="Editar cliente">
                      <i class="bi bi-pencil"></i>
                    </a>
                    <a href="<?=BASE_URL?>/clientes/<?=$cliente['id']?>/visualizar" 
                       class="btn btn-outline-success" 
                       title="Visualizar cliente">
                      <i class="bi bi-eye"></i>
                    </a>
                    <a href="<?=BASE_URL?>/clientes?delete=<?=$cliente['id']?>" 
                       class="btn btn-outline-danger" 
                       title="Excluir cliente"
                       onclick="return confirm('Tem certeza que deseja excluir este cliente?\n\nEsta ação não pode ser desfeita!')">
                      <i class="bi bi-trash"></i>
                    </a>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="card-footer text-muted d-flex justify-content-between align-items-center">
        <span><i class="bi bi-info-circle me-2"></i>Total: <strong><?=$total_clientes?></strong> cliente<?=($total_clientes!=1?'s':'')?></span>
        <?php
          $compradores = count(array_filter($clientes, fn($c) => $c['tipo_cliente'] == 'comprador'));
          $vendedores = count(array_filter($clientes, fn($c) => $c['tipo_cliente'] == 'vendedor'));
        ?>
        <div>
          <span class="badge bg-primary me-1"><?=$compradores?> comprador<?=$compradores!=1?'es':''?></span>
          <span class="badge bg-success"><?=$vendedores?> vendedor<?=$vendedores!=1?'es':''?></span>
        </div>
      </div>
    </div>
  <?php endif; ?>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
