<?php
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }
if (empty($_SESSION['logged_in'])) {
    header('Location: /troyacrm/login'); exit;
}

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

rbac_require('clientes','delete');

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
if ($id <= 0) { header("Location: {$BASE}/clientes"); exit; }

// busca cliente
try {
    $cli = fetch_one("SELECT id, nome_completo, owner_user_id FROM clients WHERE id = ?", [$id], true);
    if (!$cli) { header("Location: {$BASE}/clientes"); exit; }
} catch (Throwable $e) {
    http_response_code(500); exit('Erro ao carregar cliente.');
}

// escopo: se delete == 'own', só permite dono
$scope = rbac_scope('clientes','delete'); // 'none' | 'own' | 'all'
if ($scope === 'own') {
    $me = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);
    if (isset($cli['owner_user_id']) && (int)$cli['owner_user_id'] !== $me) {
        http_response_code(403); exit('Você não tem permissão para excluir este cliente.');
    }
}

// CSRF helpers simples (usa helpers do app se existirem)
function csrf_token_get() {
    if (function_exists('csrf_field')) { return null; } // o layout pode gerar
    if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }
    return $_SESSION['csrf'];
}
function csrf_check_local($token) {
    if (function_exists('csrf_check')) { return csrf_check(); }
    return isset($_SESSION['csrf']) && hash_equals($_SESSION['csrf'], (string)$token);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ok = csrf_check_local($_POST['csrf'] ?? '');
    if (!$ok) { http_response_code(400); exit('CSRF inválido.'); }
    try {
        execute("DELETE FROM clients WHERE id = ?", [$id]);
        header("Location: {$BASE}/clientes?deleted=1");
        exit;
    } catch (Throwable $e) {
        http_response_code(500); exit('Erro ao excluir cliente.');
    }
}

// GET => página de confirmação
$page_title = 'Excluir cliente';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
$csrf = csrf_token_get();
?>
<div class="container my-4">
  <div class="card border-danger">
    <div class="card-header bg-danger text-white">
      <i class="bi bi-trash"></i> Confirmar exclusão
    </div>
    <div class="card-body">
      <p>Tem certeza de que deseja excluir o cliente <strong><?= htmlspecialchars($cli['nome_completo']) ?></strong> (ID <?= (int)$cli['id'] ?>)?</p>
      <div class="alert alert-warning">
        <i class="bi bi-exclamation-triangle"></i> Esta ação não pode ser desfeita.
      </div>
      <form method="post" class="d-flex gap-2">
        <input type="hidden" name="id" value="<?= (int)$cli['id'] ?>">
        <?php if ($csrf): ?>
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <?php elseif (function_exists('csrf_field')): ?>
          <?= csrf_field(); ?>
        <?php endif; ?>
        <a href="<?= $BASE ?>/clientes" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> Cancelar</a>
        <button class="btn btn-danger"><i class="bi bi-trash"></i> Excluir definitivamente</button>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>