<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

/* Exige permissão de acesso ao Admin */
rbac_require('admin','access');

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

/* Página */
$page_title = 'Administração';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<style>
.admin-grid { display:grid; grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); gap:1rem; }
.admin-card { background: var(--bs-dark); border:1px solid rgba(255,255,255,.08); border-radius:.5rem; padding:1rem; }
.admin-card h5 { margin:0 0 .35rem; }
.admin-card p { margin:0 0 .75rem; color:#adb5bd; }
</style>

<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0"><i class="bi bi-gear me-2"></i>Administração</h1>
    <a class="btn btn-outline-secondary" href="<?= $BASE ?>/dashboard"><i class="bi bi-arrow-left"></i> Voltar</a>
  </div>

  <div class="admin-grid">
    <div class="admin-card">
      <h5><i class="bi bi-sliders me-1"></i>Configurações</h5>
      <p>Parâmetros do sistema (alertas de inatividade, etc.).</p>
      <a class="btn btn-primary" href="<?= $BASE ?>/admin/configuracoes">Abrir</a>
    </div>

    <div class="admin-card">
      <h5><i class="bi bi-people me-1"></i>Usuários</h5>
      <p>Gerenciar usuários, permissões e acessos.</p>
      <a class="btn btn-primary" href="<?= $BASE ?>/admin/usuarios">Abrir</a>
    </div>

    <div class="admin-card">
      <h5><i class="bi bi-arrow-left-right me-1"></i>Reatribuir Responsável</h5>
      <p>Transferir a posse (responsável) de clientes entre usuários.</p>
      <a class="btn btn-primary" href="<?= $BASE ?>/admin/reatribuir">Abrir</a>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
