<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$page_title = 'Remover Negócio';

rbac_require('negocios','delete');

$id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
if ($id <= 0) { header("Location: {$BASE}/negocios"); exit; }

$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

/* Carrega para checar escopo e mostrar título */
$deal = fetch_one("SELECT id, titulo, owner_user_id FROM deals WHERE id = ?", [$id], true);
if (!$deal) { header("Location: {$BASE}/negocios"); exit; }

/* Escopo de delete */
$delScope = rbac_scope('negocios','delete'); // 'own' | 'all'
if ($delScope === 'own' && (int)$deal['owner_user_id'] !== $me_id) {
    http_response_code(403); exit('Você não tem permissão para excluir este negócio.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        execute("DELETE FROM deals WHERE id = ?", [$id]);
        header("Location: {$BASE}/negocios?deleted=1");
        exit;
    } catch (Throwable $e) {
        http_response_code(500);
        exit('Erro ao excluir: ' . $e->getMessage());
    }
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="card border-danger">
    <div class="card-header bg-danger text-white">
      <i class="bi bi-exclamation-triangle"></i> Confirmar exclusão
    </div>
    <div class="card-body">
      <p>Tem certeza que deseja excluir o negócio <strong><?=htmlspecialchars($deal['titulo'])?></strong> (ID <?=$deal['id']?>)?</p>
      <div class="alert alert-warning"><i class="bi bi-info-circle"></i> Esta ação não pode ser desfeita.</div>
      <form method="post" class="d-flex gap-2">
        <input type="hidden" name="id" value="<?=$deal['id']?>">
        <a href="<?=$BASE?>/negocios" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> Cancelar</a>
        <button class="btn btn-danger"><i class="bi bi-trash"></i> Excluir definitivamente</button>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>