<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (empty($_SESSION['logged_in'])) { header('Location: /troyacrm/login'); exit; }

require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';

rbac_require('atendimentos','delete');

$BASE  = defined('BASE_URL') ? BASE_URL : '/troyacrm';
$me_id = (int)($_SESSION['user']['id'] ?? $_SESSION['user_id'] ?? 0);

if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }
$CSRF = $_SESSION['csrf'];

$id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
if ($id <= 0) { header('Location: '.$BASE.'/modules/atendimentos/index.php'); exit; }

$att = fetch_one("SELECT id, client_id, owner_user_id, created_by FROM interactions WHERE id = ?", [$id], true);
if (!$att) { header('Location: '.$BASE.'/modules/atendimentos/index.php'); exit; }

/* RBAC escopo */
$scopeD = rbac_scope('atendimentos','delete'); // 'own' | 'all'
if ($scopeD === 'own') {
  $owner = (int)($att['owner_user_id'] ?? 0);
  $fallback = (int)($att['created_by'] ?? 0);
  if (!in_array($me_id, [$owner, $fallback], true)) {
    http_response_code(403); exit('Sem permissão para excluir este atendimento.');
  }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!hash_equals($CSRF, (string)($_POST['csrf'] ?? ''))) {
    http_response_code(400); exit('CSRF inválido.');
  }
  try {
    execute("DELETE FROM interactions WHERE id = ?", [$id]);
    header('Location: '.$BASE.'/modules/atendimentos/index.php?deleted=1');
    exit;
  } catch (Throwable $e) {
    http_response_code(500); exit('Erro ao excluir: '.$e->getMessage());
  }
}

$page_title = 'Remover Atendimento';
include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">
  <div class="card border-danger">
    <div class="card-header bg-danger text-white">
      <i class="bi bi-trash"></i> Confirmar exclusão
    </div>
    <div class="card-body">
      <p>Tem certeza de que deseja excluir o atendimento #<?=$id?>?</p>
      <div class="alert alert-warning"><i class="bi bi-exclamation-triangle"></i> Esta ação não pode ser desfeita.</div>
      <form method="post" class="d-flex gap-2">
        <input type="hidden" name="id" value="<?=$id?>">
        <input type="hidden" name="csrf" value="<?=htmlspecialchars($CSRF)?>">
        <a href="<?=$BASE?>/modules/atendimentos/index.php" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> Cancelar</a>
        <button class="btn btn-danger"><i class="bi bi-trash"></i> Excluir definitivamente</button>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>