<?php
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/rbac.php';
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

$page_title = 'Novo usuário';
$active     = 'usuarios';
rbac_require('usuarios','create');

$__pdo = function_exists('db') ? db() : (isset($pdo) ? $pdo : ($GLOBALS['pdo'] ?? null));
if (!($__pdo instanceof PDO)) { throw new RuntimeException('Conexão PDO não encontrada.'); }

function q_one($s,$p=[]){ global $__pdo;$st=$__pdo->prepare($s);$st->execute($p);$r=$st->fetchAll(PDO::FETCH_ASSOC);return $r?$r[0]:null; }
function q_exec($s,$p=[]){ global $__pdo;$st=$__pdo->prepare($s);return $st->execute($p); }
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

$BASE = defined('BASE_URL') ? BASE_URL : '/troyacrm';

$roles = ['admin'=>'Administrador','manager'=>'Gerente','agent'=>'Corretor','media'=>'Mídia','read'=>'Leitura'];

$errors = [];
$nome   = trim($_POST['nome']   ?? '');
$email  = trim($_POST['email']  ?? '');
$role   = trim($_POST['role']   ?? 'agent');
$ativo  = isset($_POST['ativo']) ? 1 : 1; // por padrão ativo
$senha  = (string)($_POST['senha'] ?? '');

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if ($nome === '')  $errors[] = 'Informe o nome';
  if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = 'Informe um e-mail válido';
  if (!isset($roles[$role])) $role = 'agent';
  if (strlen($senha) < 6) $errors[] = 'Defina uma senha com pelo menos 6 caracteres';

  // e-mail único
  $ex = q_one("SELECT id FROM users WHERE email = ? LIMIT 1", [$email]);
  if ($ex) $errors[] = 'E-mail já cadastrado';

  if (!$errors) {
    // hash seguro (argon2id se disponível; fallback bcrypt)
    if (defined('PASSWORD_ARGON2ID')) {
      $hash = password_hash($senha, PASSWORD_ARGON2ID);
    } else {
      $hash = password_hash($senha, PASSWORD_BCRYPT);
    }

    // inserção
    $ok = q_exec(
      "INSERT INTO users (nome, email, senha_hash, role, ativo, created_at) VALUES (?,?,?,?,?, NOW())",
      [$nome, $email, $hash, $role, $ativo]
    );

    if ($ok) {
      header("Location: {$BASE}/usuarios");
      exit;
    } else {
      $errors[] = 'Falha ao salvar no banco.';
    }
  }
}

include __DIR__ . '/../../layout/header.php';
include __DIR__ . '/../../layout/nav.php';
?>
<div class="container my-4">

  <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2 mb-3">
    <div>
      <div class="d-flex align-items-center gap-2">
        <i class="bi bi-person-plus" style="font-size:1.6rem; color: var(--success);"></i>
        <h1 class="h4 m-0">Novo usuário</h1>
      </div>
      <div class="text-muted small mt-1">Preencha os dados básicos do usuário</div>
    </div>
    <div class="d-flex gap-2">
      <a href="<?= $BASE ?>/usuarios" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Voltar</a>
    </div>
  </div>

  <div class="card">
    <div class="card-header">Cadastro</div>
    <div class="card-body">
      <?php if ($errors): ?>
        <div class="alert alert-danger"><?php foreach ($errors as $e) echo '<div>'.h($e).'</div>'; ?></div>
      <?php endif; ?>

      <form method="post" autocomplete="off">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Nome <span class="text-danger">*</span></label>
            <input type="text" name="nome" class="form-control" value="<?= h($nome) ?>" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">E-mail <span class="text-danger">*</span></label>
            <input type="email" name="email" class="form-control" value="<?= h($email) ?>" required>
          </div>

          <div class="col-md-4">
            <label class="form-label">Função</label>
            <select name="role" class="form-select">
              <?php foreach ($roles as $k=>$label): ?>
                <option value="<?= h($k) ?>" <?= $role===$k?'selected':'' ?>><?= h($label) ?></option>
              <?php endforeach; ?>
            </select>
            <small class="text-muted">A função pode liberar acessos (ex.: admin).</small>
          </div>

          <div class="col-md-4">
            <label class="form-label">Senha <span class="text-danger">*</span></label>
            <input type="password" name="senha" class="form-control" placeholder="mín. 6 caracteres" required>
          </div>

          <div class="col-md-4 d-flex align-items-end">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="ativo" name="ativo" <?= $ativo? 'checked':'' ?>>
              <label class="form-check-label" for="ativo">Ativo</label>
            </div>
          </div>
        </div>

        <div class="mt-4 d-flex gap-2">
          <button class="btn btn-primary"><i class="bi bi-check2"></i> Salvar</button>
          <a href="<?= $BASE ?>/usuarios" class="btn btn-outline-secondary">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../layout/footer.php'; ?>