<?php
    $pageTitle   = "Troya Imóveis - Sobre a empresa";
    $currentPage = "sobre";
    require __DIR__ . '/inc/header.php';
?>
        <section class="page-hero">
            <div class="container page-hero-content">
                <div>
                    <p class="hero-tag">SOBRE A TROYA</p>
                    <h1>Quem somos</h1>
                    <p class="hero-subtitle">
                        Embora nossa meta seja vender, o nosso objetivo é realizar sonhos. A Troya Imóveis
                        nasceu para transformar cada negociação em uma nova fase da vida, com clareza,
                        transparência e cuidado em cada etapa.
                    </p>
                </div>
            </div>
        </section>

        <section class="section-contact">
            <div class="container">

                <!-- Estilos específicos da página Sobre (inline, não mexe no seu CSS global) -->
                <style>
                .about-columns {
                    display: grid;
                    grid-template-columns: minmax(0, 1.1fr) minmax(0, 1fr);
                    gap: 2.2rem;
                    margin-bottom: 2rem;
                }

                .about-block h2 {
                    margin-top: 0;
                    margin-bottom: 0.8rem;
                    font-size: 1.1rem;
                }

                .about-block p {
                    font-size: 0.95rem;
                    color: var(--text-soft);
                    line-height: 1.8;
                    text-align: justify;
                    text-justify: inter-word;
                }

                .about-list {
                    margin: 0.8rem 0 0;
                    padding-left: 1.1rem;
                    font-size: 0.9rem;
                    color: var(--text-soft);
                }

                .about-list li + li {
                    margin-top: 0.3rem;
                }

                .about-highlight {
                    padding: 1.3rem 1.4rem;
                    border-radius: 1.1rem;
                    background: var(--bg-soft);
                    border: 1px solid rgba(255, 255, 255, 0.14);
                    margin-top: 1.5rem;
                }

                .about-highlight h2 {
                    margin-top: 0;
                    margin-bottom: 0.6rem;
                }

                .about-highlight p {
                    font-size: 0.95rem;
                    color: var(--text-soft);
                    line-height: 1.8;
                    text-align: justify;
                    text-justify: inter-word;
                }

                @media (max-width: 768px) {
                    .about-columns {
                        grid-template-columns: minmax(0, 1fr);
                    }
                }
                </style>

                <div class="about-columns">
                    <div class="about-block">
                        <h2>Bem-vindo à Troya Imóveis</h2>
                        <p>
                            Na Troya Imóveis, acreditamos que comprar ou vender um imóvel vai muito além de uma simples
                            transação – é o início de uma nova fase na vida, repleta de possibilidades e memórias.
                        </p>
                        <p>
                            Com clareza e transparência como pilares do nosso trabalho, guiamos você em cada etapa do
                            processo, sem surpresas ou complicações desnecessárias. Embora a venda seja a meta imediata,
                            o nosso verdadeiro objetivo é realizar sonhos: ajudar você a encontrar não apenas uma casa,
                            mas um lar que reflita sua essência e suas aspirações.
                        </p>
                    </div>

                    <div class="about-block">
                        <h2>Nossa missão e valores</h2>
                        <p>
                            Nossa missão é conectar pessoas a espaços que transformem vidas, oferecendo um serviço
                            personalizado e ético, que prioriza a confiança e a excelência. Atuamos guiados por valores
                            como integridade, empatia e inovação, sempre comprometidos com a satisfação de quem nos procura.
                        </p>
                        <p>
                            Contamos com profissionais experientes, com anos de atuação no mercado imobiliário, que
                            combinam conhecimento profundo do setor com uma abordagem humana e atenciosa.
                        </p>
                        <ul class="about-list">
                            <li>Atendimento transparente e sem “letras miúdas”;</li>
                            <li>Escuta ativa para entender a real necessidade de cada cliente;</li>
                            <li>Compromisso em indicar o imóvel certo, e não apenas “qualquer” imóvel.</li>
                        </ul>
                    </div>
                </div>

                <div class="about-columns">
                    <div class="about-block">
                        <h2>Como atuamos</h2>
                        <p>
                            Na prática, isso significa acompanhar você desde o primeiro contato até a assinatura final,
                            explicando cada etapa com linguagem simples e acessível. Nosso objetivo é que você se sinta
                            seguro para tomar decisões importantes, sem pressão e com total clareza.
                        </p>
                        <p>
                            Cada consulta é tratada com cuidado: analisamos o seu perfil, suas prioridades e o momento de
                            vida em que você está, para sugerir apenas aquilo que realmente faça sentido.
                        </p>
                    </div>

                    <div class="about-block">
                        <h2>O que você encontra aqui</h2>
                        <p>
                            Na Troya Imóveis você encontra uma variedade de oportunidades: desde apartamentos aconchegantes
                            em áreas urbanas vibrantes até casas amplas em bairros tranquilos, além de propriedades
                            exclusivas para investimento.
                        </p>
                        <p>
                            Seja para morar, investir ou expandir o patrimônio, trabalhamos com imóveis cuidadosamente
                            avaliados, documentação em dia e informações claras sobre cada detalhe da negociação.
                        </p>
                    </div>
                </div>

                <div class="about-highlight">
                    <h2>Nosso convite</h2>
                    <p>
                        Estamos prontos para ouvir sua história, entender suas necessidades e te acompanhar no próximo
                        passo rumo à casa dos seus sonhos. Entre em contato com a Troya Imóveis e descubra como podemos
                        tornar sua jornada imobiliária mais leve, segura e especial.
                    </p>
                    <p>
                        <strong>Embora nossa meta seja vender, o nosso objetivo é realizar sonhos.</strong>
                    </p>
                </div>
            </div>
        </section>
<?php
    require __DIR__ . '/inc/footer.php';
?>