<?php
    require __DIR__ . '/inc/db.php';
    require __DIR__ . '/inc/functions.php';

    $pageTitle   = "Imobiliária - Encontre o imóvel dos seus sonhos";
    $currentPage = "home";

    $featuredProperties = getFeaturedProperties($pdo, 4);

    include 'inc/header.php';
?>
        <!-- HERO -->
        <section class="hero">
            <div class="container hero-grid">
                <div class="hero-text">
                    <p class="hero-tag">IMÓVEIS DE ALTO PADRÃO</p>
                    <h1>Encontre o imóvel<br>dos seus sonhos</h1>
                    <p class="hero-subtitle">
                        Experimente uma nova forma de viver. Selecione imóveis exclusivos,
                        com curadoria especial para quem busca conforto, sofisticação e segurança.
                    </p>
                    <div class="hero-actions">
                        <a href="imoveis.php" class="btn btn-primary">Ver imóveis</a>
                        <a href="sobre.php" class="btn btn-outline">Saiba mais</a>
                    </div>
                </div>
                <div class="hero-image">
                    <div class="image-overlay"></div>
                    <div class="hero-label">
                        <p>Residência Contemporânea</p>
                        <span>Bairro nobre • Vista privilegiada</span>
                    </div>
                </div>
            </div>
        </section>

        <!-- IMÓVEIS EM DESTAQUE -->
        <section id="imoveis" class="featured">
            <div class="container">
                <h2>Imóveis em destaque</h2>

                <div class="cards-grid">
                    <?php if ($featuredProperties): ?>
                        <?php foreach ($featuredProperties as $property): ?>
                            <?php include __DIR__ . '/inc/property-card.php'; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>Nenhum imóvel em destaque no momento.</p>
                    <?php endif; ?>
                </div>
            </div>
        </section>

        <!-- CONTATO RESUMIDO -->
        <section class="cta">
            <div class="container cta-grid">
                <div>
                    <p class="cta-tag">Entre em contato</p>
                    <h2>Agende uma visita ou fale com um especialista</h2>
                    <p class="cta-text">
                        Conte para nós o que você procura e vamos selecionar as melhores opções
                        de imóveis sob medida para o seu perfil.
                    </p>
                </div>
                <div class="cta-actions">
                    <a href="contato.php" class="btn btn-primary full-width">Fale conosco</a>
                    <p class="cta-note">Atendimento de segunda a sexta, das 9h às 18h.</p>
                </div>
            </div>
        </section>
<?php
    include 'inc/footer.php';
?>
