<?php
    require __DIR__ . '/inc/db.php';
    require __DIR__ . '/inc/functions.php';

    $pageTitle   = "Troya Imóveis - Imóveis selecionados e atendimento humano";
    $currentPage = "home";

    // Imóveis em destaque
    $featuredProperties = getFeaturedProperties($pdo, 4);

    include __DIR__ . '/inc/header.php';
?>
        <!-- HERO PRINCIPAL -->
        <section class="hero">
            <div class="container hero-grid">
                <div class="hero-text">
                    <p class="hero-tag">TROYA IMÓVEIS</p>
                    <h1>Mais do que vender imóveis,<br>nosso propósito é realizar sonhos.</h1>
                    <p class="hero-subtitle">
                        Na Troya Imóveis, cada imóvel é o começo de uma nova fase. Trabalhamos com clareza,
                        transparência e um atendimento realmente humano para que você se sinta seguro em cada decisão.
                    </p>
                    <div class="hero-actions">
                        <a href="imoveis.php" class="btn btn-primary">Ver imóveis</a>
                        <a href="sobre.php" class="btn btn-outline">Saiba mais</a>
                    </div>
                </div>
                <div class="hero-image">
                    <div class="image-overlay"></div>
                    <div class="hero-label">
                        <p>Imóveis selecionados com cuidado</p>
                        <span>Cada imóvel escolhido como se fosse para nós</span>
                    </div>
                </div>
            </div>
        </section>

        <!-- IMÓVEIS EM DESTAQUE -->
        <section class="featured">
            <div class="container">
                <h2>Imóveis em destaque</h2>

                <div class="cards-grid">
                    <?php if ($featuredProperties): ?>
                        <?php foreach ($featuredProperties as $property): ?>
                            <?php include __DIR__ . '/inc/property-card.php'; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>Nenhum imóvel em destaque no momento. Em breve, novas oportunidades estarão disponíveis.</p>
                    <?php endif; ?>
                </div>
            </div>
        </section>

        <!-- BLOCO INSTITUCIONAL RESUMIDO -->
        <section class="cta">
            <div class="container cta-grid">
                <div>
                    <p class="cta-tag">SOBRE A TROYA IMÓVEIS</p>
                    <h2>Clareza, cuidado e imóveis que fazem sentido para você</h2>
                    <p class="cta-text">
                        Mais do que mostrar opções, nosso papel é entender o seu momento de vida e indicar apenas
                        os imóveis que realmente conversam com o que você procura, seja um novo lar, um investimento
                        ou uma oportunidade para o seu negócio.
                    </p>
                </div>
                <div class="cta-actions">
                    <a href="sobre.php" class="btn btn-outline full-width">Conhecer a Troya Imóveis</a>
                    <p class="cta-note">
                        Embora nossa meta seja vender, o nosso objetivo é realizar sonhos – com informação clara,
                        transparência e respeito ao seu tempo.
                    </p>
                </div>
            </div>
        </section>
<?php
    include __DIR__ . '/inc/footer.php';
?>
