<?php
// Espera receber $property (linha do banco) e $pdo carregado.

$photoUrl   = getPropertyMainPhoto($pdo, (int) $property['id']);
$badgeText  = ($property['finalidade'] ?? '') === 'aluguel' ? 'Para alugar' : 'À venda';
$badgeClass = ($property['finalidade'] ?? '') === 'aluguel' ? 'badge-rent' : '';

$bairro  = trim((string) ($property['bairro'] ?? ''));
$cidade  = trim((string) ($property['cidade'] ?? ''));
$local   = $bairro && $cidade ? $bairro . ' • ' . $cidade : ($cidade ?: $bairro);

$meta = [];
if (!empty($property['quartos']))   { $meta[] = 'Quartos ' . $property['quartos']; }
if (!empty($property['suites']))    { $meta[] = 'Suítes ' . $property['suites']; }
if (!empty($property['banheiros'])) { $meta[] = 'Banheiros ' . $property['banheiros']; }
if (!empty($property['vagas']))     { $meta[] = 'Vagas ' . $property['vagas']; }

$detailUrl = 'imovel.php?id=' . (int) $property['id'];
?>
<article class="property-card">
    <a href="<?php echo $detailUrl; ?>" class="property-card-link">
        <div class="card-badge <?php echo $badgeClass; ?>"><?php echo htmlspecialchars($badgeText); ?></div>
        <div class="card-image"<?php if ($photoUrl) { echo ' style="background-image: url(\'' . htmlspecialchars($photoUrl) . '\');"'; } ?>></div>
        <div class="card-body">
            <h3><?php echo htmlspecialchars($property['titulo']); ?></h3>
            <?php if ($local): ?>
                <p class="card-location"><?php echo htmlspecialchars($local); ?></p>
            <?php endif; ?>

            <?php if ($meta): ?>
            <div class="card-meta">
                <?php foreach ($meta as $item): ?>
                    <span><?php echo htmlspecialchars($item); ?></span>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>

            <p class="card-price"><?php echo formatPrice((float) $property['preco']); ?></p>
        </div>
    </a>
</article>
