<?php
// Garante que os dados de contato estejam disponíveis
if (!defined('TROYA_WHATSAPP_DISPLAY')) {
    @include __DIR__ . '/config.php';
}
?>
        <footer class="footer">
            <div class="container footer-content">
                <p>© <?php echo date('Y'); ?> Troya Imóveis. Todos os direitos reservados.</p>
                <p class="footer-credits footer-whatsapp-row">
                    <span class="whatsapp-icon-circle"></span>
                    <span>Fale conosco também pelo WhatsApp:</span>
                    <a href="https://wa.me/<?php echo TROYA_WHATSAPP_NUM; ?>" target="_blank" rel="noopener">
                        <?php echo htmlspecialchars(TROYA_WHATSAPP_DISPLAY); ?>
                    </a>
                </p>
            </div>

            <style>
            .footer-whatsapp-row {
                display: flex;
                align-items: center;
                gap: 0.4rem;
                flex-wrap: wrap;
            }
            .footer-whatsapp-row a {
                color: var(--gold-soft);
                text-decoration: none;
            }
            .footer-whatsapp-row a:hover {
                text-decoration: underline;
            }
            .whatsapp-icon-circle {
                width: 18px;
                height: 18px;
                border-radius: 999px;
                background: #25D366; /* verde WhatsApp */
                display: inline-block;
                position: relative;
            }
            .whatsapp-icon-circle::after {
                content: "\260E"; /* símbolo de telefone simples */
                position: absolute;
                inset: 0;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 11px;
                color: #ffffff;
            }
            @media (max-width: 640px) {
                .footer-whatsapp-row {
                    align-items: flex-start;
                }
            }
            </style>
        </footer>
    </main>
</body>
</html>
