<?php
require __DIR__ . '/inc/db.php';
require __DIR__ . '/inc/functions.php';

$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;

if ($id <= 0) {
    http_response_code(404);
    $property = null;
} else {
    $property = getPropertyById($pdo, $id);
}

if (!$property) {
    $pageTitle   = "Imóvel não encontrado";
    $currentPage = "";
    include __DIR__ . '/inc/header.php';
    ?>
    <section class="page-hero">
        <div class="container page-hero-content">
            <div>p
                <p class="hero-tag">IMÓVEL INDISPONÍVEL</p>
                <h1>Ops, não encontramos esse imóvel</h1>
                <p class="hero-subtitle">
                    Ele pode ter sido removido, estar reservado ou o link pode estar incorreto.
                </p>
            </div>
        </div>
    </section>

    <section class="section-contact">
        <div class="container">
            <p style="margin-bottom: 1.5rem;">
                Se você estava interessado em um imóvel específico, fale com nossa equipe para encontrar
                alternativas semelhantes.
            </p>
            <a href="imoveis.php" class="btn btn-outline">Voltar para a lista de imóveis</a>
        </div>
    </section>
    <?php
    include __DIR__ . '/inc/footer.php';
    exit;
}

$pageTitle   = $property['titulo'] . " - Detalhes do imóvel";
$currentPage = "";

// Fotos e características
$photos   = getPropertyPhotos($pdo, (int) $property['id']);
$features = getPropertyFeatures($pdo, (int) $property['id'], 24);

$photoMain = $photos[0]['path'] ?? null;

// Array simples só com URLs das fotos para o JS
$photoUrls = [];
foreach ($photos as $p) {
    if (!empty($p['path'])) {
        $photoUrls[] = $p['path'];
    }
}

$bairro  = trim((string) ($property['bairro'] ?? ''));
$cidade  = trim((string) ($property['cidade'] ?? ''));
$uf      = trim((string) ($property['uf'] ?? ''));

$local = $bairro;
if ($cidade) {
    $local = $local ? $local . ' • ' . $cidade : $cidade;
}
if ($uf) {
    $local = $local ? $local . ' / ' . $uf : $uf;
}

$badgeText  = ($property['finalidade'] ?? '') === 'aluguel' ? 'Para alugar' : 'À venda';
$badgeClass = ($property['finalidade'] ?? '') === 'aluguel' ? 'badge-rent' : '';

include __DIR__ . '/inc/header.php';
?>
<section class="property-hero">
    <div class="container property-hero-content">
        <div>
            <p class="hero-tag">IMÓVEL EM DESTAQUE</p>
            <h1><?php echo htmlspecialchars($property['titulo']); ?></h1>
            <?php if ($local): ?>
                <p class="property-location-line"><?php echo htmlspecialchars($local); ?></p>
            <?php endif; ?>
            <div class="property-tags">
                <span class="pill <?php echo $badgeClass; ?>">
                    <?php echo htmlspecialchars($badgeText); ?>
                </span>
                <?php if (!empty($property['tipo'])): ?>
                    <span class="pill pill-outline">
                        <?php echo htmlspecialchars(ucfirst($property['tipo'])); ?>
                    </span>
                <?php endif; ?>
            </div>
        </div>

        <div class="property-price-block">
            <p class="property-price-big">
                <?php echo formatPrice((float) $property['preco']); ?>
            </p>
            <p class="property-price-note">
                Valor sujeito a alteração sem aviso prévio.
            </p>
            <a href="contato.php" class="btn btn-primary full-width">Quero saber mais</a>
        </div>
    </div>
</section>

<section class="property-layout">
    <div class="container property-layout-grid">
        <div class="property-gallery">
            <?php
            $styleMain = '';
            if ($photoMain) {
                $styleMain = " style=\"background-image: url('" . htmlspecialchars($photoMain, ENT_QUOTES, 'UTF-8') . "');\"";
            }
            ?>
            <div class="gallery-main"<?php echo $styleMain; ?>></div>

            <?php if (count($photos) > 1): ?>
                <div class="gallery-thumbs">
                    <?php foreach ($photos as $photo): ?>
                        <?php
                        $thumbStyle = '';
                        if (!empty($photo['path'])) {
                            $thumbStyle = " style=\"background-image: url('" . htmlspecialchars($photo['path'], ENT_QUOTES, 'UTF-8') . "');\"";
                        }
                        ?>
                        <div class="gallery-thumb"<?php echo $thumbStyle; ?>></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <aside class="property-sidebar">
            <div class="info-block">
                <h2>Resumo do imóvel</h2>
                <div class="info-grid">
                    <?php if (!empty($property['quartos'])): ?>
                        <div class="info-item">
                            <span class="info-label">Quartos</span>
                            <span class="info-value"><?php echo (int) $property['quartos']; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($property['suites'])): ?>
                        <div class="info-item">
                            <span class="info-label">Suítes</span>
                            <span class="info-value"><?php echo (int) $property['suites']; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($property['banheiros'])): ?>
                        <div class="info-item">
                            <span class="info-label">Banheiros</span>
                            <span class="info-value"><?php echo (int) $property['banheiros']; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($property['vagas'])): ?>
                        <div class="info-item">
                            <span class="info-label">Vagas</span>
                            <span class="info-value"><?php echo (int) $property['vagas']; ?></span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($property['area_construida_m2'])): ?>
                        <div class="info-item">
                            <span class="info-label">Área construída</span>
                            <span class="info-value">
                                <?php echo (float) $property['area_construida_m2']; ?> m²
                            </span>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($property['area_lote_m2'])): ?>
                        <div class="info-item">
                            <span class="info-label">Área do terreno</span>
                            <span class="info-value">
                                <?php echo (float) $property['area_lote_m2']; ?> m²
                            </span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="info-block">
                <h2>Localização</h2>
                <p class="info-text">
                    <?php if (!empty($property['endereco'])): ?>
                        <?php echo htmlspecialchars($property['endereco']); ?><br>
                    <?php endif; ?>

                    <?php if ($bairro): ?>
                        <?php echo htmlspecialchars($bairro); ?> •
                    <?php endif; ?>

                    <?php if ($cidade): ?>
                        <?php echo htmlspecialchars($cidade); ?>
                    <?php endif; ?>

                    <?php if ($uf): ?>
                        / <?php echo htmlspecialchars($uf); ?>
                    <?php endif; ?>

                    <?php if (!empty($property['cep'])): ?>
                        <br>CEP <?php echo htmlspecialchars($property['cep']); ?>
                    <?php endif; ?>
                </p>
            </div>

            <div class="info-block">
                <h2>Próximos passos</h2>
                <p class="info-text">
                    Ficou interessado neste imóvel? Entre em contato com nossa equipe para agendar uma visita
                    ou tirar suas dúvidas sobre condições comerciais.
                </p>
                <a href="contato.php" class="btn btn-outline full-width">Falar com um consultor</a>
            </div>
        </aside>
    </div>
</section>

<?php if (!empty($property['descricao'])): ?>
<section class="property-description">
    <div class="container">
        <h2>Descrição do imóvel</h2>
        <p><?php echo nl2br(htmlspecialchars($property['descricao'])); ?></p>
    </div>
</section>
<?php endif; ?>

<?php if ($features): ?>
<section class="property-features">
    <div class="container">
        <h2>Características</h2>
        <div class="feature-chips">
            <?php foreach ($features as $feature): ?>
                <span class="feature-chip">
                    <?php echo htmlspecialchars($feature['nome']); ?>
                </span>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<?php
// Lightbox / carrossel de fotos
$jsPhotoArray = json_encode($photoUrls, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
?>

<div class="lightbox" id="photo-lightbox">
    <div class="lightbox-backdrop"></div>
    <div class="lightbox-inner">
        <button type="button" class="lightbox-close" aria-label="Fechar">&times;</button>
        <button type="button" class="lightbox-arrow lightbox-prev" aria-label="Imagem anterior">&#10094;</button>
        <div class="lightbox-image"></div>
        <button type="button" class="lightbox-arrow lightbox-next" aria-label="Próxima imagem">&#10095;</button>
    </div>
</div>


<script>
document.addEventListener('DOMContentLoaded', function () {
    var photoUrls = <?php echo $jsPhotoArray ?: '[]'; ?>;
    if (!photoUrls.length) return;

    var lightbox      = document.getElementById('photo-lightbox');
    var imageDiv      = lightbox.querySelector('.lightbox-image');
    var btnClose      = lightbox.querySelector('.lightbox-close');
    var btnPrev       = lightbox.querySelector('.lightbox-prev');
    var btnNext       = lightbox.querySelector('.lightbox-next');
    var backdrop      = lightbox.querySelector('.lightbox-backdrop');
    var currentIndex  = 0;

    function showImage(index) {
        if (!photoUrls.length) return;
        if (index < 0) index = photoUrls.length - 1;
        if (index >= photoUrls.length) index = 0;
        currentIndex = index;
        imageDiv.style.backgroundImage = "url('" + photoUrls[currentIndex].replace(/'/g, "\'") + "')";
    }

    function openLightbox(index) {
        if (!photoUrls.length) return;
        showImage(index);
        lightbox.classList.add('open');
        document.body.style.overflow = 'hidden';
    }

    function closeLightbox() {
        lightbox.classList.remove('open');
        document.body.style.overflow = '';
    }

    btnClose.addEventListener('click', function () {
        closeLightbox();
    });

    backdrop.addEventListener('click', function () {
        closeLightbox();
    });

    btnPrev.addEventListener('click', function () {
        showImage(currentIndex - 1);
    });

    btnNext.addEventListener('click', function () {
        showImage(currentIndex + 1);
    });

    document.addEventListener('keydown', function (e) {
        if (!lightbox.classList.contains('open')) return;
        if (e.key === 'Escape') {
            closeLightbox();
        } else if (e.key === 'ArrowLeft') {
            showImage(currentIndex - 1);
        } else if (e.key === 'ArrowRight') {
            showImage(currentIndex + 1);
        }
    });

    var main = document.querySelector('.gallery-main');
    if (main) {
        main.style.cursor = 'pointer';
        main.addEventListener('click', function () {
            openLightbox(currentIndex);
        });
    }

    var thumbs = document.querySelectorAll('.gallery-thumb');
    thumbs.forEach(function (thumb, index) {
        thumb.style.cursor = 'pointer';
        thumb.addEventListener('click', function () {
            currentIndex = index;
            if (main) {
                main.style.backgroundImage = "url('" + photoUrls[currentIndex].replace(/'/g, "\'") + "')";
            }
        });
    });
});
</script>

<?php
include __DIR__ . '/inc/footer.php';
