<?php
    require __DIR__ . '/inc/db.php';
    require __DIR__ . '/inc/functions.php';

    $pageTitle   = "Troya Imóveis - Portfólio de oportunidades";
    $currentPage = "imoveis";

    $filters = [
        'tipo'       => $_GET['tipo']       ?? '',
        'finalidade' => $_GET['finalidade'] ?? '',
        'cidade'     => $_GET['cidade']     ?? '',
    ];

    $properties = searchProperties($pdo, $filters, 24);

    include __DIR__ . '/inc/header.php';
?>
        <section class="page-hero">
            <div class="container page-hero-content">
                <div>
                    <p class="hero-tag">NOSSO PORTFÓLIO</p>
                    <h1>Imóveis selecionados para você</h1>
                    <p class="hero-subtitle">
                        Uma seleção enxuta de imóveis para compra e locação.
                        Use os filtros ao lado para refinar a busca sem perder a clareza.
                    </p>
                </div>
                <form class="filters" method="get" action="imoveis.php">
                    <div class="filter-group">
                        <label for="finalidade">Finalidade</label>
                        <select id="finalidade" name="finalidade">
                            <option value="">Compra ou locação</option>
                            <option value="venda"   <?php echo ($filters['finalidade'] === 'venda')   ? 'selected' : ''; ?>>Comprar</option>
                            <option value="aluguel" <?php echo ($filters['finalidade'] === 'aluguel') ? 'selected' : ''; ?>>Alugar</option>
                        </select>
                    </div>
                    <div class="filter-group">
                        <label for="tipo">Tipo</label>
                        <select id="tipo" name="tipo">
                            <option value="">Todos os tipos</option>
                            <option value="casa"        <?php echo ($filters['tipo'] === 'casa')        ? 'selected' : ''; ?>>Casa</option>
                            <option value="apartamento" <?php echo ($filters['tipo'] === 'apartamento') ? 'selected' : ''; ?>>Apartamento</option>
                            <option value="cobertura"   <?php echo ($filters['tipo'] === 'cobertura')   ? 'selected' : ''; ?>>Cobertura</option>
                        </select>
                    </div>
                    <div class="filter-group">
                        <label for="cidade">Cidade</label>
                        <input
                            type="text"
                            id="cidade"
                            name="cidade"
                            placeholder="Ex.: Caldas Novas"
                            value="<?php echo htmlspecialchars($filters['cidade']); ?>"
                        >
                    </div>
                    <button type="submit" class="btn btn-primary small">Filtrar</button>
                </form>
            </div>
        </section>

        <section class="featured featured-inner">
            <div class="container">
                <div class="cards-grid">
                    <?php if ($properties): ?>
                        <?php foreach ($properties as $property): ?>
                            <?php include __DIR__ . '/inc/property-card.php'; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>Nenhum imóvel encontrado com os filtros atuais.</p>
                    <?php endif; ?>
                </div>
            </div>
        </section>
<?php
    include __DIR__ . '/inc/footer.php';
?>
