<?php
    require __DIR__ . '/inc/db.php';
    require __DIR__ . '/inc/functions.php';

    $pageTitle   = "Troya Imóveis - Imóveis selecionados e atendimento humano";
    $currentPage = "home";

    // Imóveis em destaque (já usados no grid)
    $featuredProperties = getFeaturedProperties($pdo, 4);

    // Vamos usar os mesmos imóveis em destaque no HERO
    $heroProperties = $featuredProperties;

    // Lista de condomínios (tabela condominios)
    $condominios = getCondominios($pdo);

    include __DIR__ . '/inc/header.php';
?>
        <!-- HERO PRINCIPAL -->
        <section class="hero">
            <div class="container hero-grid">
                <div class="hero-text">
                    <p class="hero-tag">TROYA IMÓVEIS</p>
                    <h1>Mais do que vender imóveis,<br>nosso propósito é realizar sonhos.</h1>
                    <p class="hero-subtitle">
                        Na Troya Imóveis, cada imóvel é o começo de uma nova fase. Trabalhamos com clareza,
                        transparência e um atendimento realmente humano para que você se sinta seguro em cada decisão.
                    </p>
                    <div class="hero-actions">
                        <a href="imoveis.php" class="btn btn-primary">Ver imóveis</a>
                        <a href="sobre.php" class="btn btn-outline">Saiba mais</a>
                    </div>
                </div>

                <!-- HERO COM SLIDER DE IMÓVEIS -->
                <div class="hero-image" data-hero-slider>
                    <div class="image-overlay"></div>

                    <?php
                        $temSlides  = false;
                        $primeiroAtivoDefinido = false;
                    ?>

                    <?php if (!empty($heroProperties)): ?>
                        <?php foreach ($heroProperties as $heroProperty): ?>
                            <?php
                                // Usa a mesma função do card
                                $heroPhoto = getPropertyMainPhoto($pdo, (int)$heroProperty['id']);
                                if (!$heroPhoto) {
                                    continue; // pula imóvel sem foto
                                }

                                $temSlides = true;

                                // o primeiro imóvel COM foto recebe a classe is-active
                                $classes = 'hero-slide';
                                if (!$primeiroAtivoDefinido) {
                                    $classes .= ' is-active';
                                    $primeiroAtivoDefinido = true;
                                }
                            ?>
                            <div class="<?php echo $classes; ?>"
                                 data-bg="<?php echo htmlspecialchars($heroPhoto); ?>">
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>

                    <div class="hero-label">
                        <p>Imóveis selecionados com cuidado</p>
                        <span>Cada imóvel escolhido como se fosse para nós</span>
                    </div>
                </div>
            </div>
        </section>

        <!-- IMÓVEIS EM DESTAQUE -->
        <section class="featured">
            <div class="container">
                <h2>Imóveis em destaque</h2>

                <!-- FILTRO RÁPIDO NA HOME (manda para imoveis.php) -->
                <form class="featured-filters" method="get" action="imoveis.php" style="margin-bottom: 1.5rem;">
                    <div style="display: flex; flex-wrap: wrap; gap: 0.75rem; align-items: flex-end;">

                        <!-- Finalidade -->
                        <div style="min-width: 160px;">
                            <label for="finalidade_home"
                                   style="display:block;font-size:0.8rem;margin-bottom:0.25rem;">
                                Finalidade
                            </label>
                            <select id="finalidade_home"
                                    name="finalidade"
                                    class="js-fake-select"
                                    style="width:100%;">
                                <option value="">Venda ou aluguel</option>
                                <option value="venda">Somente venda</option>
                                <option value="aluguel">Somente aluguel</option>
                            </select>
                        </div>

                        <!-- Condomínio -->
                        <div style="min-width: 260px;">
                            <label for="condominio_home"
                                   style="display:block;font-size:0.8rem;margin-bottom:0.25rem;">
                                Condomínio
                            </label>
                            <select id="condominio_home"
                                    name="condominio"
                                    class="js-fake-select"
                                    style="width:100%;">
                                <option value="">Todos</option>
                                <?php if (!empty($condominios)): ?>
                                    <?php foreach ($condominios as $cond): ?>
                                        <option value="<?php echo htmlspecialchars($cond['nome']); ?>">
                                            <?php echo htmlspecialchars($cond['nome']); ?>
                                            <?php if (!empty($cond['cidade'])): ?>
                                                <?php
                                                    $cidadeUf = $cond['cidade'];
                                                    if (!empty($cond['uf'])) {
                                                        $cidadeUf .= ' / ' . $cond['uf'];
                                                    }
                                                ?>
                                                - <?php echo htmlspecialchars($cidadeUf); ?>
                                            <?php endif; ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <!-- Faixa de valor mínima -->
                        <div style="min-width: 180px;">
                            <label for="preco_min_home"
                                   style="display:block;font-size:0.8rem;margin-bottom:0.25rem;">
                                Valor mín.
                            </label>
                            <select id="preco_min_home"
                                    name="preco_min"
                                    class="js-fake-select"
                                    style="width:100%;">
                                <option value="">Sem mínimo</option>
                                <option value="200000">a partir de R$ 200 mil</option>
                                <option value="300000">a partir de R$ 300 mil</option>
                                <option value="500000">a partir de R$ 500 mil</option>
                                <option value="800000">a partir de R$ 800 mil</option>
                                <option value="1000000">a partir de R$ 1 milhão</option>
                            </select>
                        </div>

                        <!-- Faixa de valor máxima -->
                        <div style="min-width: 185px;">
                            <label for="preco_max_home"
                                   style="display:block;font-size:0.8rem;margin-bottom:0.25rem;">
                                Valor máx.
                            </label>
                            <select id="preco_max_home"
                                    name="preco_max"
                                    class="js-fake-select"
                                    style="width:100%;">
                                <option value="">Sem máximo</option>
                                <option value="300000">até R$ 300 mil</option>
                                <option value="500000">até R$ 500 mil</option>
                                <option value="800000">até R$ 800 mil</option>
                                <option value="1000000">até R$ 1 milhão</option>
                                <option value="1500000">até R$ 1,5 milhões</option>
                                <option value="2000000">até R$ 2 milhões</option>
                                <option value="ACIMA_2000000">acima de R$ 2 milhões</option>
                            </select>
                        </div>

                        <!-- Botão -->
                        <div>
                            <button type="submit" class="btn btn-outline">
                                Filtrar imóveis
                            </button>
                        </div>
                    </div>
                </form>

                <div class="cards-grid">
                    <?php if ($featuredProperties): ?>
                        <?php foreach ($featuredProperties as $property): ?>
                            <?php include __DIR__ . '/inc/property-card.php'; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>Nenhum imóvel em destaque no momento. Em breve, novas oportunidades estarão disponíveis.</p>
                    <?php endif; ?>
                </div>
            </div>
        </section>

        <!-- BLOCO INSTITUCIONAL RESUMIDO -->
        <section class="cta">
            <div class="container cta-grid">
                <div>
                    <p class="cta-tag">SOBRE A TROYA IMÓVEIS</p>
                    <h2>Clareza, cuidado e imóveis que fazem sentido para você</h2>
                    <p class="cta-text">
                        Mais do que mostrar opções, nosso papel é entender o seu momento de vida e indicar apenas
                        os imóveis que realmente conversam com o que você procura, seja um novo lar, um investimento
                        ou uma oportunidade para o seu negócio.
                    </p>
                </div>
                <div class="cta-actions">
                    <a href="sobre.php" class="btn btn-outline full-width">Conhecer a Troya Imóveis</a>
                    <p class="cta-note">
                        Embora nossa meta seja vender, o nosso objetivo é realizar sonhos – com informação clara,
                        transparência e respeito ao seu tempo.
                    </p>
                </div>
            </div>
        </section>

        <!-- SCRIPT ESPECÍFICO PARA LAZY-LOAD DO HERO -->
        <script>
        document.addEventListener('DOMContentLoaded', function () {
            const heroSlider = document.querySelector('[data-hero-slider]');
            if (!heroSlider) return;

            const slides = heroSlider.querySelectorAll('.hero-slide[data-bg]');
            if (!slides.length) return;

            function loadSlideBg(slide) {
                if (!slide) return;
                if (slide.dataset.bgLoaded === '1') return;

                const bg = slide.getAttribute('data-bg');
                if (!bg) return;

                slide.style.backgroundImage = "url('" + bg.replace(/'/g, "\\'") + "')";
                slide.dataset.bgLoaded = '1';
            }

            // Carrega imediatamente o slide que já está ativo
            const active = heroSlider.querySelector('.hero-slide.is-active');
            if (active) {
                loadSlideBg(active);
            }

            // Observa mudanças na classe (quando o slider do footer troca os slides)
            const observer = new MutationObserver(function (mutations) {
                mutations.forEach(function (mutation) {
                    if (mutation.type === 'attributes' && mutation.attributeName === 'class') {
                        const el = mutation.target;
                        if (el.classList.contains('hero-slide') && el.classList.contains('is-active')) {
                            loadSlideBg(el);
                        }
                    }
                });
            });

            slides.forEach(function (slide) {
                observer.observe(slide, { attributes: true });
            });
        });
        </script>
<?php
    include __DIR__ . '/inc/footer.php';
?>