<?php
    if (!isset($pageTitle)) {
        $pageTitle = "Troya Imóveis - Encontre o imóvel dos seus sonhos";
    }
    if (!isset($currentPage)) {
        $currentPage = "";
    }
?><!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- ESTILOS APENAS PARA AJUSTE DO MENU (DESKTOP x MOBILE) -->
    <style>
    /* Menu mobile começa escondido */
    .nav-mobile {
        display: none;
    }

    .nav-mobile-link {
        text-decoration: none;
        font-size: 0.85rem;
        letter-spacing: 0.14em;
        text-transform: uppercase;
        color: var(--text-soft);
        white-space: nowrap;
    }

    .nav-mobile-link.active {
        color: var(--text-main);
        border-bottom: 2px solid var(--gold);
        padding-bottom: 0.2rem;
    }

    @media (max-width: 768px) {
        /* Mantém o topo como já está */
        .topbar-content {
            padding-block: 0.8rem;
        }

        /* Esconde o menu desktop no mobile */
        .nav {
            display: none;
        }

        /* Mostra o menu mobile logo abaixo do header */
        .nav-mobile {
            display: flex;
            justify-content: center;
            gap: 1.5rem;
            padding: 0.65rem 1.2rem 0.75rem;
            border-top: 1px solid rgba(255, 255, 255, 0.08);
            border-bottom: 1px solid rgba(255, 255, 255, 0.08);
            background: #050506;
        }
    }
    </style>
</head>
<body>
    <header class="topbar">
        <div class="container topbar-content">
            <a href="index" class="logo">
                <img src="assets/img/logo-troya.png" alt="Troya Imóveis" class="logo-img">
            </a>

            <!-- MENU DESKTOP -->
            <nav class="nav">
                <a href="index"
                   class="nav-link <?php echo $currentPage === 'home' ? 'active' : ''; ?>">
                    Início
                </a>

                <a href="imoveis"
                   class="nav-link <?php echo $currentPage === 'imoveis' ? 'active' : ''; ?>">
                    Imóveis
                </a>

                <a href="sobre"
                   class="nav-link <?php echo $currentPage === 'sobre' ? 'active' : ''; ?>">
                    Sobre a Troya
                </a>

                <a href="contato"
                   class="nav-link <?php echo $currentPage === 'contato' ? 'active' : ''; ?>">
                    Contato
                </a>

                <div class="nav-icons">
                    <span class="icon">&#9825;</span>
                    <span class="icon">&#9881;</span>
                </div>
            </nav>
        </div>

        <!-- MENU MOBILE (APENAS CELULAR) -->
        <nav class="nav-mobile">
            <a href="index"
               class="nav-mobile-link <?php echo $currentPage === 'home' ? 'active' : ''; ?>">
                Início
            </a>

            <a href="imoveis"
               class="nav-mobile-link <?php echo $currentPage === 'imoveis' ? 'active' : ''; ?>">
                Imóveis
            </a>

            <a href="sobre"
               class="nav-mobile-link <?php echo $currentPage === 'sobre' ? 'active' : ''; ?>">
                Sobre a Troya
            </a>

            <a href="contato"
               class="nav-mobile-link <?php echo $currentPage === 'contato' ? 'active' : ''; ?>">
                Contato
            </a>
        </nav>
    </header>
    <main>