<?php
// Garante que os dados de contato estejam disponíveis
if (!defined('TROYA_WHATSAPP_DISPLAY')) {
    @include __DIR__ . '/config.php';
}
?>
        <footer class="footer">
            <div class="container footer-content">
                <p>© <?php echo date('Y'); ?> Troya Imóveis. Todos os direitos reservados.</p>
            </div>
        </footer>

        <?php if (defined('TROYA_WHATSAPP_NUM') && TROYA_WHATSAPP_NUM): ?>
            <!-- Botão flutuante do WhatsApp -->
            <a
                href="https://wa.me/<?php echo TROYA_WHATSAPP_NUM; ?>"
                class="whatsapp-fab"
                target="_blank"
                rel="noopener"
                aria-label="Falar com a Troya Imóveis pelo WhatsApp"
            >
                <img src="assets/whatsapp-icon.png" alt="WhatsApp">
            </a>
        <?php endif; ?>

        <script>
        document.addEventListener('DOMContentLoaded', function () {

            /* -----------------------------------------
               1) SLIDER DO HERO
            ----------------------------------------- */
            (function () {
                const heroSlider = document.querySelector('[data-hero-slider]');
                if (!heroSlider) return;

                const slides = heroSlider.querySelectorAll('.hero-slide');
                if (slides.length <= 1) return; // só uma imagem, não precisa rodar

                let current = 0;
                const interval = 5000; // 5 segundos

                setInterval(() => {
                    slides[current].classList.remove('is-active');
                    current = (current + 1) % slides.length;
                    slides[current].classList.add('is-active');
                }, interval);
            })();

            /* -----------------------------------------
               2) SELECTS FAKE BONITOS (.js-fake-select)
            ----------------------------------------- */
            (function () {
                const selects = document.querySelectorAll('select.js-fake-select');
                if (!selects.length) return;

                function closeAllExcept(exceptWrapper) {
                    document.querySelectorAll('.select-fake-wrapper.is-open').forEach(function (wrap) {
                        if (wrap !== exceptWrapper) {
                            wrap.classList.remove('is-open');
                        }
                    });
                }

                selects.forEach(function (select) {
                    // evita duplicar se o script rodar mais de uma vez
                    if (select.dataset.enhanced === '1') return;
                    select.dataset.enhanced = '1';

                    const wrapper = document.createElement('div');
                    wrapper.className = 'select-fake-wrapper';

                    // botão "visível" que mostra o valor selecionado
                    const displayBtn = document.createElement('button');
                    displayBtn.type = 'button';
                    displayBtn.className = 'select-fake-display';

                    const textSpan = document.createElement('span');
                    textSpan.className = 'select-fake-text';

                    const selectedOption = select.options[select.selectedIndex] || select.options[0];
                    textSpan.textContent = selectedOption ? selectedOption.text : 'Selecione';

                    displayBtn.appendChild(textSpan);

                    // dropdown de opções
                    const optionsBox = document.createElement('div');
                    optionsBox.className = 'select-fake-options';

                    Array.from(select.options).forEach(function (opt) {
                        const optDiv = document.createElement('div');
                        optDiv.className = 'select-fake-option';
                        optDiv.textContent = opt.text;
                        optDiv.dataset.value = opt.value;

                        if (opt.selected) {
                            optDiv.classList.add('is-selected');
                        }

                        optDiv.addEventListener('click', function () {
                            // atualiza o select real
                            select.value = opt.value;

                            // dispara evento change (caso tenha algum listener futuro)
                            const ev = new Event('change', { bubbles: true });
                            select.dispatchEvent(ev);

                            // atualiza texto exibido
                            textSpan.textContent = opt.text;

                            // marca selecionado no dropdown
                            optionsBox.querySelectorAll('.select-fake-option').forEach(function (el) {
                                el.classList.remove('is-selected');
                            });
                            optDiv.classList.add('is-selected');

                            // fecha dropdown
                            wrapper.classList.remove('is-open');
                        });

                        optionsBox.appendChild(optDiv);
                    });

                    // injeta estrutura: wrapper > select (escondido) + display + opções
                    const parent = select.parentNode;
                    parent.insertBefore(wrapper, select);
                    wrapper.appendChild(select);
                    wrapper.appendChild(displayBtn);
                    wrapper.appendChild(optionsBox);

                    // esconde visualmente o select original, mas mantém no DOM para submit
                    select.style.position = 'absolute';
                    select.style.opacity = '0';
                    select.style.pointerEvents = 'none';
                    select.style.left = '0';
                    select.style.top = '0';
                    select.style.width = '100%';
                    select.style.height = '100%';

                    // abre/fecha dropdown
                    displayBtn.addEventListener('click', function (e) {
                        e.preventDefault();
                        const isOpen = wrapper.classList.contains('is-open');
                        closeAllExcept(wrapper);
                        if (!isOpen) {
                            wrapper.classList.add('is-open');
                        } else {
                            wrapper.classList.remove('is-open');
                        }
                    });
                });

                // fecha ao clicar fora
                document.addEventListener('click', function (e) {
                    const clickedWrapper = e.target.closest('.select-fake-wrapper');
                    if (!clickedWrapper) {
                        closeAllExcept(null);
                    }
                });
            })();

        });
        </script>
    </main>
</body>
</html>