<?php
    require __DIR__ . '/inc/db.php';
    require __DIR__ . '/inc/functions.php';

    $pageTitle   = "Troya Imóveis - Portfólio de oportunidades";
    $currentPage = "imoveis";

    // Filtros vindos da URL
    $filters = [
        'tipo'       => '', // não estamos usando tipo aqui
        'finalidade' => $_GET['finalidade'] ?? '',
        'cidade'     => '', // não usamos cidade no formulário
        'condominio' => $_GET['condominio'] ?? '',
        'preco_min'  => $_GET['preco_min'] ?? '',
        'preco_max'  => $_GET['preco_max'] ?? '',
    ];

    // Lista de condomínios (tabela condominios)
    $condominios = getCondominios($pdo);

    // Busca imóveis
    $properties = searchProperties($pdo, $filters, 24);

    include __DIR__ . '/inc/header.php';
?>
        <section class="page-hero">
            <div class="container">
                <div class="page-hero-content" style="flex-direction: column; align-items: flex-start; gap: 1.8rem;">
                    <div>
                        <p class="hero-tag">NOSSO PORTFÓLIO</p>
                        <h1>Imóveis selecionados para você</h1>
                        <p class="hero-subtitle">
                            Uma seleção enxuta de imóveis para compra e locação.
                            Use os filtros abaixo para refinar a busca sem perder a
                            clareza.
                        </p>
                    </div>

                    <!-- Filtros horizontais (igual home) -->
                    <form class="featured-filters" method="get" action="imoveis">
                        <div style="display: flex; flex-wrap: wrap; gap: 0.75rem; align-items: flex-end;">

                            <!-- Finalidade -->
                            <div style="min-width: 160px;">
                                <label for="finalidade"
                                       style="display:block;font-size:0.8rem;margin-bottom:0.25rem;">
                                    Finalidade
                                </label>
                                <select id="finalidade"
                                        name="finalidade"
                                        class="js-fake-select">
                                    <option value=""
                                        <?php echo $filters['finalidade'] === '' ? 'selected' : ''; ?>>
                                        Compra ou locação
                                    </option>
                                    <option value="venda"
                                        <?php echo $filters['finalidade'] === 'venda' ? 'selected' : ''; ?>>
                                        Somente venda
                                    </option>
                                    <option value="aluguel"
                                        <?php echo $filters['finalidade'] === 'aluguel' ? 'selected' : ''; ?>>
                                        Somente aluguel
                                    </option>
                                </select>
                            </div>

                            <!-- Condomínio -->
                            <div style="min-width: 260px;">
                                <label for="condominio"
                                       style="display:block;font-size:0.8rem;margin-bottom:0.25rem;">
                                    Condomínio
                                </label>
                                <select id="condominio"
                                        name="condominio"
                                        class="js-fake-select">
                                    <option value=""
                                        <?php echo $filters['condominio'] === '' ? 'selected' : ''; ?>>
                                        Todos
                                    </option>
                                    <?php if (!empty($condominios)): ?>
                                        <?php foreach ($condominios as $cond): ?>
                                            <?php
                                                $nome  = $cond['nome'];
                                                $value = $nome;
                                                $selected = ($filters['condominio'] === $value) ? 'selected' : '';

                                                $cidadeUf = '';
                                                if (!empty($cond['cidade'])) {
                                                    $cidadeUf = $cond['cidade'];
                                                    if (!empty($cond['uf'])) {
                                                        $cidadeUf .= ' / ' . $cond['uf'];
                                                    }
                                                }
                                            ?>
                                            <option value="<?php echo htmlspecialchars($value); ?>" <?php echo $selected; ?>>
                                                <?php echo htmlspecialchars($nome); ?>
                                                <?php if ($cidadeUf): ?>
                                                    - <?php echo htmlspecialchars($cidadeUf); ?>
                                                <?php endif; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>

                            <!-- Valor mín. -->
                            <div style="min-width: 200px;">
                                <label for="preco_min"
                                       style="display:block;font-size:0.8rem;margin-bottom:0.25rem;">
                                    Valor mín.
                                </label>
                                <select id="preco_min"
                                        name="preco_min"
                                        class="js-fake-select">
                                    <option value=""
                                        <?php echo $filters['preco_min'] === '' ? 'selected' : ''; ?>>
                                        Sem mínimo
                                    </option>
                                    <option value="200000"
                                        <?php echo $filters['preco_min'] === '200000' ? 'selected' : ''; ?>>
                                        a partir de R$ 200 mil
                                    </option>
                                    <option value="300000"
                                        <?php echo $filters['preco_min'] === '300000' ? 'selected' : ''; ?>>
                                        a partir de R$ 300 mil
                                    </option>
                                    <option value="500000"
                                        <?php echo $filters['preco_min'] === '500000' ? 'selected' : ''; ?>>
                                        a partir de R$ 500 mil
                                    </option>
                                    <option value="800000"
                                        <?php echo $filters['preco_min'] === '800000' ? 'selected' : ''; ?>>
                                        a partir de R$ 800 mil
                                    </option>
                                    <option value="1000000"
                                        <?php echo $filters['preco_min'] === '1000000' ? 'selected' : ''; ?>>
                                        a partir de R$ 1 milhão
                                    </option>
                                </select>
                            </div>

                            <!-- Valor máx. -->
                            <div style="min-width: 200px;">
                                <label for="preco_max"
                                       style="display:block;font-size:0.8rem;margin-bottom:0.25rem;">
                                    Valor máx.
                                </label>
                                <select id="preco_max"
                                        name="preco_max"
                                        class="js-fake-select">
                                    <option value=""
                                        <?php echo $filters['preco_max'] === '' ? 'selected' : ''; ?>>
                                        Sem máximo
                                    </option>
                                    <option value="300000"
                                        <?php echo $filters['preco_max'] === '300000' ? 'selected' : ''; ?>>
                                        até R$ 300 mil
                                    </option>
                                    <option value="500000"
                                        <?php echo $filters['preco_max'] === '500000' ? 'selected' : ''; ?>>
                                        até R$ 500 mil
                                    </option>
                                    <option value="800000"
                                        <?php echo $filters['preco_max'] === '800000' ? 'selected' : ''; ?>>
                                        até R$ 800 mil
                                    </option>
                                    <option value="1000000"
                                        <?php echo $filters['preco_max'] === '1000000' ? 'selected' : ''; ?>>
                                        até R$ 1 milhão
                                    </option>
                                    <option value="1500000"
                                        <?php echo $filters['preco_max'] === '1500000' ? 'selected' : ''; ?>>
                                        até R$ 1,5 milhões
                                    </option>
                                </select>
                            </div>

                            <!-- Botão -->
                            <div>
                                <button type="submit" class="btn btn-primary small">
                                    Filtrar
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </section>

        <section class="featured featured-inner">
            <div class="container">
                <div class="cards-grid">
                    <?php if ($properties): ?>
                        <?php foreach ($properties as $property): ?>
                            <?php include __DIR__ . '/inc/property-card.php'; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p>Nenhum imóvel encontrado com os filtros atuais.</p>
                    <?php endif; ?>
                </div>
            </div>
        </section>
<?php
    include __DIR__ . '/inc/footer.php';
?>