<?php
    require __DIR__ . '/inc/db.php';
    require __DIR__ . '/inc/functions.php';
    require __DIR__ . '/inc/config.php';

    $pageTitle   = "Troya Imóveis - Fale conosco";
    $currentPage = "contato";

    $formSent  = false;
    $formError = '';
    $nome      = '';
    $email     = '';
    $telefone  = '';
    $tipo      = '';
    $mensagem  = '';

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Honeypot simples para evitar spam de robô
        if (!empty($_POST['website'])) {
            // Campo escondido preenchido = provável bot
        } else {
            $nome     = trim($_POST['nome']     ?? '');
            $email    = trim($_POST['email']    ?? '');
            $telefone = trim($_POST['telefone'] ?? '');
            $tipo     = trim($_POST['tipo']     ?? '');
            $mensagem = trim($_POST['mensagem'] ?? '');

            if ($nome === '' || $email === '' || $mensagem === '') {
                $formError = 'Por favor, preencha pelo menos nome, e-mail e mensagem.';
            } else {
                $to      = TROYA_EMAIL;
                $subject = 'Novo contato pelo site - Troya Imóveis';
                $body    = "Novo contato pelo site Troya Imóveis:\n\n"
                         . "Nome: {$nome}\n"
                         . "E-mail: {$email}\n"
                         . "Telefone/WhatsApp: {$telefone}\n"
                         . "Tipo de imóvel: {$tipo}\n"
                         . "Mensagem:\n{$mensagem}\n";

                $headers = "From: Troya Imóveis <" . TROYA_EMAIL . ">" . "\r\n"
                         . "Reply-To: {$nome} <{$email}>" . "\r\n"
                         . "Content-Type: text/plain; charset=UTF-8" . "\r\n";

                if (@mail($to, $subject, $body, $headers)) {
                    $formSent  = true;
                    $nome      = '';
                    $email     = '';
                    $telefone  = '';
                    $tipo      = '';
                    $mensagem  = '';
                } else {
                    $formError = 'Não foi possível enviar sua mensagem agora. Tente novamente em instantes.';
                }
            }
        }
    }

    require __DIR__ . '/inc/header.php';
?>
        <section class="page-hero">
            <div class="container page-hero-content">
                <div>
                    <p class="hero-tag">FALE COM A TROYA</p>
                    <h1>Entre em contato</h1>
                    <p class="hero-subtitle">
                        Conte pra gente em que momento você está. Vamos analisar com calma
                        e responder com orientação humana, sem empurrar nenhum imóvel à força.
                    </p>
                </div>
            </div>
        </section>

        <section id="contato" class="section-contact">
            <div class="container contact-grid">

                <style>
                .form-alert {
                    padding: 0.85rem 1rem;
                    border-radius: 0.8rem;
                    font-size: 0.85rem;
                    margin-bottom: 1rem;
                }
                .form-alert.success {
                    background: rgba(46, 160, 90, 0.12);
                    border: 1px solid rgba(46, 160, 90, 0.8);
                    color: #b7f5c8;
                }
                .form-alert.error {
                    background: rgba(200, 80, 80, 0.12);
                    border: 1px solid rgba(200, 80, 80, 0.8);
                    color: #ffd2d2;
                }
                /* Justificar texto da coluna "Como funciona o nosso atendimento" */
                .contact-info .contact-text,
                .contact-info .contact-list {
                    text-align: justify;
                }
                </style>

                <!-- sem action: envia para a própria contato.php / contato -->
                <form class="contact-form" method="post">
                    <?php if ($formSent): ?>
                        <div class="form-alert success">
                            Sua mensagem foi enviada com sucesso! Em breve entraremos em contato.
                        </div>
                    <?php elseif ($formError): ?>
                        <div class="form-alert error">
                            <?php echo htmlspecialchars($formError); ?>
                        </div>
                    <?php endif; ?>

                    <!-- Honeypot escondido -->
                    <input type="text" name="website" style="display:none">

                    <div class="field">
                        <label for="nome">Nome completo</label>
                        <input
                            type="text"
                            id="nome"
                            name="nome"
                            placeholder="Digite seu nome"
                            value="<?php echo htmlspecialchars($nome); ?>"
                        >
                    </div>
                    <div class="field">
                        <label for="email">E-mail</label>
                        <input
                            type="email"
                            id="email"
                            name="email"
                            placeholder="voce@exemplo.com"
                            value="<?php echo htmlspecialchars($email); ?>"
                        >
                    </div>
                    <div class="field">
                        <label for="telefone">Telefone / WhatsApp</label>
                        <input
                            type="text"
                            id="telefone"
                            name="telefone"
                            placeholder="(00) 00000-0000"
                            value="<?php echo htmlspecialchars($telefone); ?>"
                        >
                    </div>
                    <div class="field">
                        <label for="tipo">Tipo de imóvel desejado</label>
                        <select id="tipo" name="tipo" class="js-fake-select">
                            <option value="">Selecione</option>
                            <option value="casa"        <?php echo $tipo === 'casa' ? 'selected' : ''; ?>>Casa</option>
                            <option value="apartamento" <?php echo $tipo === 'apartamento' ? 'selected' : ''; ?>>Apartamento</option>
                            <option value="cobertura"   <?php echo $tipo === 'cobertura' ? 'selected' : ''; ?>>Cobertura</option>
                            <option value="terreno"     <?php echo $tipo === 'terreno' ? 'selected' : ''; ?>>Terreno</option>
                            <option value="comercial"   <?php echo $tipo === 'comercial' ? 'selected' : ''; ?>>Comercial</option>
                        </select>
                    </div>
                    <div class="field full">
                        <label for="mensagem">Mensagem</label>
                        <textarea
                            id="mensagem"
                            name="mensagem"
                            rows="4"
                            placeholder="Conte um pouco sobre o que você procura, orçamento aproximado e região de interesse"
                        ><?php echo htmlspecialchars($mensagem); ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary full-width">Enviar mensagem</button>
                </form>

                <div class="contact-info">
                    <h2>Como funciona o nosso atendimento</h2>
                    <p class="contact-text">
                        Cada mensagem é lida por alguém da equipe, sem respostas automáticas.
                        Nosso objetivo é entender o seu contexto antes de sugerir qualquer imóvel.
                    </p>
                    <ul class="contact-list">
                        <li>
                            <strong>Retorno rápido:</strong> respondemos às mensagens recebidas pelo site
                            em horário comercial, dando prioridade a quem já está em fase de decisão.
                        </li>
                        <li>
                            <strong>Seleção criteriosa de imóveis:</strong> usamos as informações do formulário
                            para sugerir apenas o que faz sentido para o seu momento.
                        </li>
                        <li>
                            <strong>Respeito ao seu tempo:</strong> nada de ligações insistentes ou
                            disparos de mensagens. Você decide como quer continuar a conversa.
                        </li>
                        <li>
                            <strong>Prefere WhatsApp?</strong> é só clicar no ícone verde no canto da tela
                            para falar diretamente com a Troya Imóveis.
                        </li>
                    </ul>
                </div>
            </div>
        </section>
<?php
    require __DIR__ . '/inc/footer.php';
?>